#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>

#include "private_messages_callbacks.h"
#include "private_messages.h"
#include "support.h"
#include "global.h"
#include "stuff.h"
#include "networking.h"


gboolean
on_private_messages_window_delete_event
                                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_set_sensitive(private_messages,TRUE);
	gtk_widget_hide(private_messages_window);
  return TRUE;
  
}




void
on_send_private_message_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
//printf("Send message\n");
gchar *get_send_to,*get_message_text;
gchar string_to_send[1000];
	
// Am I connected ?
	if(connection_status != 1 ) {
		write_message_statusbar("Cannot send message. You are not connected.");
	return;
	}
	
	//load_preferences();
	//printf("Send message cliked.\n");
	 GtkWidget* send_to = lookup_widget(GTK_WIDGET(button),"send_to");
	 GtkWidget* private_message_text = lookup_widget(GTK_WIDGET(button),"private_message_text");
	
	
	get_send_to= gtk_entry_get_text(GTK_ENTRY(send_to));
	get_message_text = gtk_entry_get_text(GTK_ENTRY(private_message_text));
	
	if((strcmp(get_send_to,"") == 0) || (strcmp(get_message_text,"") == 0))  {
	//printf("Missing message info.\n");
		write_message_statusbar("Cannot send message. Fill all fields please.");
		return;	
		}
	get_send_to = uppercase(get_send_to);
	
	//printf("From: %s - To: %s - Text: %s\n",xwota_settings.call,get_send_to,get_message_text);
	
	// :MSENDTO|This is the message|FROM|<EOR>
	
	sprintf(string_to_send,":M%s|%s|%s|<EOR>",get_send_to,get_message_text,xwota_settings.call);

	//printf("%s\n",string_to_send);	
	tx(readchan,string_to_send);
	gtk_entry_set_text(GTK_ENTRY(private_message_text),"");
	write_message_statusbar("Sent.");
	decode_text_message(string_to_send);
	
}

	



void
on_close_private_messages_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
gtk_widget_set_sensitive(private_messages,TRUE);
	gtk_widget_hide(private_messages_window);
	
}



void
on_help_private_messages_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_private_message_text_activate       (GtkEntry        *entry,
                                        gpointer         user_data)
{
	GtkWidget *send_private_message_button = lookup_widget(GTK_WIDGET(private_messages_window),"send_to");
	on_send_private_message_button_clicked (send_private_message_button,NULL);

}
