#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>

#include "xwota_main_callback.h"
#include "xwota_main.h"
#include "support.h"
#include "manual.h"
#include "about.h"
#include "global.h"
#include "default_preferences.h"
#include "station_info.h"
#include "stuff.h"
#include "networking.h"


void
on_update_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
//printf ("Update.\n");
	char program_name[40];
	char string_to_send[1000];
	char frequency_entry[100],comment_entry[100];
	gchar *get_frequency,*get_comment;
	int wota_status;
	
	strcpy(program_name,"Xwota 0.4");
	load_preferences();
	
	if (connection_status != 1) {
		write_main_statusbar("Failed to send. Xwota not connected.");
	return;	
	}
	else if (strcmp(xwota_settings.call,"NOCALL") == 0) {
		write_main_statusbar("Failed to send. Station info not configured.");
		return;
	}
	
	
	get_frequency= gtk_entry_get_text(GTK_ENTRY(frequency));
	get_comment = gtk_entry_get_text(GTK_ENTRY(comment));
	
	strcpy(frequency_entry,get_frequency);
	strcpy(comment_entry,get_comment);
	
	if(strcmp(get_frequency,old_freq) == 0) {
		wota_status = 2;
	}
	else {
		wota_status = 1;
		old_freq = g_strdup(get_frequency);
	}
	
//	printf("Freq %s - Comment %s\n",frequency_entry,comment_entry);

// Compongo la stringa da inviare al server WOTA
//Call|Frequency|Country|PAS|Grid|SAS|Latitude|Longitude|Status|Comment|Program Name|Future 1|Future 2|<EOR>
sprintf(string_to_send,"%s|%s|%s|%s|%s|%s|%s|%s|%d|%s|%s|f1|f2|<EOR>",xwota_settings.call,frequency_entry,xwota_settings.country,xwota_settings.state,xwota_settings.grid,xwota_settings.county,xwota_settings.latitude,xwota_settings.longitude,wota_status,comment_entry,program_name);
//printf("%s\n",string_to_send);
tx(readchan,string_to_send);  // Send spot to WOTA DB
	
}


void
on_participate_changed                 (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
	automatic_upload();
//printf("Participate !\n");
}


void
on_hamlib_read_changed                 (GtkComboBox     *combobox,
                                        gpointer         user_data)
{

}


void
on_autoanswer_changed                  (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
//printf("Autoanswer changed.\n");
}


void
on_connect_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
//printf("Connecting to WOTADB...\n");
	int connection_result;
	//gchar string_to_send[1000];
	
	//GtkWidget *xwota =  lookup_widget(GTK_WIDGET(menuitem),"xwota");
	//gtk_widget_set_sensitive(xwota,FALSE);
// Starting networing
connection_result =	init_network();
	
	if (connection_result == 1) {
	//gtk_widget_set_sensitive(xwota,TRUE);
		
	GtkWidget *connect =  lookup_widget(GTK_WIDGET(menuitem),"connect");
	GtkWidget *disconnect =  lookup_widget(GTK_WIDGET(menuitem),"disconnect");
		gtk_widget_set_sensitive(connect,FALSE);
		gtk_widget_set_sensitive(disconnect,TRUE);
		write_main_statusbar("Connected");
		
		connection_status = 1;

		// Qui mettere il controllo del participate
		upload_event_id= g_timeout_add(3000000,automatic_upload,NULL);
		check_freq_event_id = g_timeout_add(5000,check_freq,NULL);
		
	//printf("Upload event id: %d Check freq id %d\n",upload_event_id,check_freq_event_id);
		//retry last spots
		//sprintf(string_to_send,":L%s|<EOR>",xwota_settings.call);
		//tx(readchan,string_to_send);
		}
	 else  {
	//gtk_widget_set_sensitive(xwota,TRUE);
	GtkWidget *connect =  lookup_widget(GTK_WIDGET(menuitem),"connect");
	gtk_widget_set_sensitive(connect,TRUE);
	GtkWidget *disconnect =  lookup_widget(GTK_WIDGET(menuitem),"disconnect");
	gtk_widget_set_sensitive(disconnect,FALSE); 
		write_main_statusbar("Connection failed to the server");
		connection_status = 0;	
		 
		 }

	
}


void
on_disconnect_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	printf("Disconnecting from WOTA...");
	disconnect_network(sockfd,readchan);
	GtkWidget *connect =  lookup_widget(GTK_WIDGET(menuitem),"connect");
	gtk_widget_set_sensitive(connect,TRUE);
	GtkWidget *disconnect =  lookup_widget(GTK_WIDGET(menuitem),"disconnect");
	gtk_widget_set_sensitive(disconnect,FALSE);
	write_main_statusbar("Disconnected");
	connection_status = 0;
	
	

}


void
on_check_updates1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (connection_status == 1) {
	disconnect_network(sockfd,readchan);
}
printf("Bye bye from Xwota\n");
gtk_main_quit();
}


void
on_private_messages_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

	gtk_widget_show(private_messages_window);
	gtk_widget_set_sensitive(private_messages,FALSE);
	
}


void
on_group_messages_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_statistics_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_station_info_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

station_info_window=create_station_info_window();
gtk_widget_show(station_info_window);
gtk_widget_set_sensitive(station_info,FALSE);
load_preferences();

	
	GtkWidget* call = lookup_widget(GTK_WIDGET(station_info_window),"call");
	GtkWidget* country = lookup_widget(GTK_WIDGET(station_info_window),"country");
	GtkWidget* state = lookup_widget(GTK_WIDGET(station_info_window),"state");
	GtkWidget* grid = lookup_widget(GTK_WIDGET(station_info_window),"grid");
	GtkWidget* county = lookup_widget(GTK_WIDGET(station_info_window),"county");
	GtkWidget* latitude = lookup_widget(GTK_WIDGET(station_info_window),"latitude");
	GtkWidget* longitude = lookup_widget(GTK_WIDGET(station_info_window),"longitude");	
	
	gtk_entry_set_text (GTK_ENTRY (call), xwota_settings.call);
    gtk_entry_set_text (GTK_ENTRY (country),xwota_settings.country);
	gtk_entry_set_text (GTK_ENTRY (state), xwota_settings.state);
	gtk_entry_set_text (GTK_ENTRY (grid), xwota_settings.grid);
	gtk_entry_set_text (GTK_ENTRY (county), xwota_settings.county);
	gtk_entry_set_text (GTK_ENTRY (latitude), xwota_settings.latitude);
	gtk_entry_set_text (GTK_ENTRY (longitude),xwota_settings.longitude);
	
}


void
on_default_preferences_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

	default_preferences_window=create_default_preferences_window();
	gtk_widget_show(default_preferences_window);

	load_preferences();
	
	GtkWidget * default_frequency = lookup_widget(GTK_WIDGET(default_preferences_window),"default_frequency");
	GtkWidget * default_comment = lookup_widget(GTK_WIDGET(default_preferences_window),"default_comment");
	GtkWidget * default_participate = lookup_widget(GTK_WIDGET(default_preferences_window),"default_participate");
	GtkWidget * default_read_from_rig = lookup_widget(GTK_WIDGET(default_preferences_window),"default_read_from_rig");
	GtkWidget * default_autoanswer = lookup_widget(GTK_WIDGET(default_preferences_window),"default_autoanswer");
	
// Setting fields as defined in conf file.
	
	gtk_entry_set_text (GTK_ENTRY (default_frequency), xwota_settings.freq);
    gtk_entry_set_text (GTK_ENTRY (default_comment),xwota_settings.comments);
// setting combos
	
if(strcmp(xwota_settings.participate,"0") == 0) {
gtk_combo_box_set_active(GTK_COMBO_BOX (default_participate),0);
}
else {
gtk_combo_box_set_active(GTK_COMBO_BOX (default_participate),1);
}	


if(strcmp(xwota_settings.read_from_rig,"0")== 0) {
	gtk_combo_box_set_active(GTK_COMBO_BOX (default_read_from_rig),0);
}
else {
gtk_combo_box_set_active(GTK_COMBO_BOX (default_read_from_rig),1);
}

if(strcmp(xwota_settings.autoanswer,"0") == 0) {
	gtk_combo_box_set_active(GTK_COMBO_BOX (default_autoanswer),0);	
}	
else {
	gtk_combo_box_set_active(GTK_COMBO_BOX (default_autoanswer),1);	
}	


gtk_widget_set_sensitive(default_preferences,FALSE);
}


void
on_private_messages_settings_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
private_messages_settings_window=create_private_messages_settings_window();
gtk_widget_show(private_messages_settings_window);

load_preferences();
GtkWidget * autoanswer_text_entry = lookup_widget(GTK_WIDGET(private_messages_settings_window),"autoanswer_text_entry");
GtkWidget * save_private_messages_combo = lookup_widget(GTK_WIDGET(private_messages_settings_window),"save_private_messages_combo");
GtkWidget * sound_private_messages_combo = lookup_widget(GTK_WIDGET(private_messages_settings_window),"sound_private_messages_combo");
	
gtk_entry_set_text (GTK_ENTRY (autoanswer_text_entry), xwota_settings.autoanswer_text);
	
if(strcmp(xwota_settings.save_private_messages,"1") == 0) {
gtk_combo_box_set_active(GTK_COMBO_BOX (save_private_messages_combo),1);
}
else {
gtk_combo_box_set_active(GTK_COMBO_BOX (save_private_messages_combo),0);
}	


if(strcmp(xwota_settings.sound_private_messages,"0")== 0) {
	gtk_combo_box_set_active(GTK_COMBO_BOX (sound_private_messages_combo),0);
}
else {
gtk_combo_box_set_active(GTK_COMBO_BOX (sound_private_messages_combo),1);
}	
	
	
	
	
gtk_widget_set_sensitive(private_messages_settings,FALSE);
	
}




void
on_rig_control_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
//printf("Rig combo changed.\n");
}


void
on_help_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_manual_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

	manual_window=create_manual_window();
	gtk_widget_show(manual_window);
	gtk_widget_set_sensitive(manual,FALSE);
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

	about_window=create_about_window();
	gtk_widget_show(about_window);
	//gtk_widget_set_sensitive(about,FALSE);
}


gboolean
on_xwota_main_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
if (connection_status == 1) {
	disconnect_network(sockfd,readchan);
}
	printf("Bye bye from Xwota.\n");
	gtk_main_quit();
 return 0;
}


void
on_check_updates_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
//printf("Checking for a new version of Xwota...\n");
}

void
on_query_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
query_window=create_query_window();
gtk_widget_show(query_window);
gtk_widget_set_sensitive(query,FALSE);
}


void
on_search_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}
