#ifndef __BACKGROUND_H
#define __BACKGROUND_H



#include "color.h"
#include "vector3d.h"
#include "texture.h"
//#include "surface.h"
#include "targaIO.h"

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

__BEGIN_YAFRAY

struct renderState_t;

class YAFRAYCORE_EXPORT background_t
{
	public:
		virtual color_t operator () (const vector3d_t &dir,renderState_t &state)const=0;
		virtual ~background_t() {};
};

// used in image and HDR background,
// later moved elsewhere to be used with general texture mapping
inline void spheremap(const vector3d_t &dir, PFLOAT &u, PFLOAT &v)
{
  PFLOAT phi = (dir.z>1.0)?M_PI:((dir.z<-1.0)?0.0:acos(-dir.z));
  v = 1.0 - phi*M_1_PI;
  if (((v<1e-5) && (v>-1e-5)) || (v==1.0))
    u = 0.0;
  else {
    PFLOAT theta = -dir.x / sin(phi);
    theta = (theta>1.0)?0.0:((theta<-1.0)?0.5:acos(theta)/(M_PI*2.0));
    u = (dir.y>0.0)?theta:(1.0-theta);
  }
}

__END_YAFRAY

#endif
