#include <sigc++/thread_tunnel.h>

#include <uc++/plugin.h>

#include "python-script.h"
#include "python-loader.h"

using namespace SigC;
using namespace uC;

using namespace SigC::Threads;
using namespace uC::Script;

namespace uC
{

namespace Script
{

class PythonPlugin : public Plugin, 
		     public Thread,
		     public StandardDispatcher
{
  public:
    PythonPlugin(PluginManager *mgr);
    virtual ~PythonPlugin();
    virtual std::string name() const { return "python"; }
    virtual std::string description() const { return "Python support"; }
    Language& language() { return *lang_; }
    
    // Thread
    virtual void *main(void *arg) { run(); return arg; }
  private:
    Language *lang_;
    pythonObjectFactory obj_factory_;
    pythonObject root_ns_;
    ThreadTunnel tunnel_;
};

PythonPlugin::PythonPlugin(PluginManager *mgr)
  : Plugin(mgr),  root_ns_(obj_factory_), tunnel_(this)
{
  lang_ = manage(new Language(root_ns_.namespace_interface(), 
			      obj_factory_, &tunnel_));
}

PythonPlugin::~PythonPlugin()
{
  //manager()->unregister_language("python");
}

} // Script

} // uC

extern "C" uC::Plugin *ucxx_python_plugin_init(uC::PluginManager *mgr)
{
  if (!Py_IsInitialized())
    Py_Initialize();

  try
  {
    uC::Script::PythonPlugin *plugin = 
      SigC::manage(new uC::Script::PythonPlugin(mgr));
    
    // Start thread
    plugin->start();
    
    mgr->load_plugin("ucxx"); // We need to pre-load this
    mgr->register_language("python",  plugin->language());
    mgr->register_plugin_loader(manage(new pythonPluginLoader(mgr)));

    return(plugin);
  }
  catch (...)
  {
    mgr->set_error("PythonPlugin initialisation failed");
    return 0;
  }
}


