/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_UCXX_ERROR_HANDLER_H)
#define __INC_UCXX_ERROR_HANDLER_H

#include <string>

#include <sigc++/signal_system.h>

namespace uC
{

using namespace std;

/** The ErrorHandler
 */
class ErrorHandler : public SigC::Object
{
  public:
    enum
    {
      LOG_ERROR,
      LOG_CRITICAL,
      LOG_WARNING,
      LOG_MESSAGE,
      LOG_INFO,
      LOG_DEBUG
    };
    
    /// Constructor
    ErrorHandler(ErrorHandler *parent = 0) : parent_(parent) { }

    /// The parent object, or NULL
    ErrorHandler *parent() { return(parent_); }

    /// see parent() 
    const ErrorHandler *parent() const { return(parent_); }

    /// Set the parent object
    void set_parent(ErrorHandler *parent) { parent_ = parent; }
    
    /** Emit an error */
    void emit_error(const string& message) {
      if (!error.emit(message) && parent_)
        parent_->emit_error(message);
    }
    void emit_log(int level, const string& message) {
      if (!log.emit(level, message) && parent_)
        parent_->emit_log(level, message);
    }
    
    /** Emitted when a error ocurred.
     * \return boolean; if false, pass the error up to the parent object.
     */
    SigC::Signal1<bool, const string&> error;
    
    SigC::Signal2<bool, int, const string&> log;
  private:
    ErrorHandler *parent_;
};

}
#endif
