/*

	Audio playstacks.

	Acts as `bookmarks' for the number of audio files
	currently being played.

 */

#ifndef PLAYSTACK_H
#define PLAYSTACK_H

#include "afw.h"
#include "ytypes.h"


typedef struct {

	/*   Audio file format wrapper, contains data about file
	 *   associated with this play stack.
	 */
	AFWDataStruct afw_data;


	/*   ID Code to identify this PlayStack.  A set of PlayStacks
	 *   owned by a certain single owner (see below) may not
	 *   (should not) have duplicate yid codes.
	 */
	YID yid;

	/*  Owner of this PlayStack.  This reffers to a connection
	 *  number.
	 */
	YConnectionNumber owner;

	/* Permissions of this PlayStack. */
	YPermission permission;


	/* Current play position in audio data. */
	YDataPosition position;

	/* Entire length of audio data. */
	YDataLength data_length;

	/* Applied sample rate (convert actual sample rate to this).
	 * This value has no affect if the sound object is of type
	 * SndObjTypeMIDI.
	 */
	int applied_sample_rate;


	/* Block alignment. */
	YDataPosition block_align;

	/* Current block alighment */
	YDataPosition cur_block;

	/* Total blocks. */
	YDataLength block_length;


	/* DSP buffer. */
	SoundBuffer *dsp_buf;
	YDataLength	dsp_buf_len,		/* Allocated size of dsp_buf. */
			dsp_buf_data_len;	/* Non-garbage data length. */

	/* Repeat counter, the number of times the audio data
	 * has been completely played.
	 */
	int repeats;

	/* Number of times to play. Or -1 to play infinatly
	 * or untill owner destroys this playstack.
	 */
	int total_repeats;

	/* Volume (for DSP type sound objects only). */
	Coefficient	volume_left,
			volume_right;

} PlayStack;

extern PlayStack **playstack;
extern int total_playstacks;


extern int PlayStackIsAllocated(int n);
extern PlayStack *PlayStackGetPtr(int n);

extern int PlayStackAllocate();
extern void PlayStackReset(int n);
extern void PlayStackDelete(int n);

extern void PlayStackDeleteAll();
extern void PlayStackReclaim();


#endif	/* PLAYSTACK_H */
