/*
	Network connections.
 */

#ifndef YCONNECTION_H
#define YCONNECTION_H

#include "ytypes.h"



typedef struct {

	/* Primary transfer socket, -1 means not connected. */
	int socket;

	/* Login name. */
	char *name;

	/* Crypt()ed password. */
	char *password;

	/*   Address of host (numeric or named address) that
	 *   connectino comes from.
	 */
	YIPUnion ip;

	/* User and group ID of connection. */
	YID	user_id;
	YID	group_id;

	/* Access level. */
	AccessLevel access_level;

	/* Recieve buffer. */
	u_int8_t *buf;
	YDataLength buf_cont, buf_len;

} YConnection;

extern YConnection **yconnection;
extern int total_yconnections;


/*
 *	Functions:
 */
extern int ConnectionIsAllocated(int n);
extern int ConnectionIsConnected(int n);
extern YConnection *ConnectionGetPtr(int n);

extern int ConnectionAllocate();
extern void ConnectionReset(int n);
extern void ConnectionDelete(int n);

extern void ConnectionDeleteAll();
extern void ConnectionReclaim();


#endif	/* YCONNECTION_H */
