#ifndef CONFIG_H
#define CONFIG_H


/*
 *	Default YIFF Sound Server configuration file:
 */
#define YC_DEF_CONFIG_FILE		"/usr/etc/yiffrc"
#define YC_DEF_CONFIG_FILE_DIR		"/usr/etc"

/*
 *	Default YIFF Sound Server program file:
 */
#define YC_DEF_YIFF_PROGRAM		"/usr/sbin/yiff"
#define YC_DEF_YIFF_PROGRAM_DIR		"/usr/sbin"

/*
 *	Default DSP device path:
 */
#define YC_DEF_DSP_DEVICE		"/dev/dsp"
#define YC_DEF_DSP_DEVICE_DIR		"/dev"

/*
 *	Default mixer device path:
 */
#define YC_DEF_MIXER_DEVICE		"/dev/mixer"
#define YC_DEF_MIXER_DEVICE_DIR		"/dev"

/*
 *	Default YIFF Sound Server restart script:
 */
#define YC_DEF_START_SCRIPT		"/usr/sbin/starty"
#define YC_DEF_START_SCRIPT_DIR		"/usr/sbin"


/*
 *	Default address:
 */
#define YC_DEF_ADDRESS		"127.0.0.1"

/*
 *	Default port number (in string form):
 */
#define YC_DEF_PORT		"9433"

/*
 *	Default midi play command:
 */
#define YC_DEF_MIDI_PLAY_CMD		"/usr/bin/pmidi -p 65:0 %f"
#define YC_DEF_MIDI_PLAY_CMD_DIR	"/usr/bin"


/*
 *	ALSA midi device port (value as a string):
 */
#define YC_DEF_ALSA_MIDI_PORT	"0"



/*
 *	Show tool tips by default (TRUE or FALSE):
 */
#define YC_DEF_SHOW_TOOL_TIPS	TRUE

/*
 *	Default toplevel window size (in pixels):
 */
#define YC_DEF_WIDTH		500
#define YC_DEF_HEIGHT		400


/*
 *	Mnimum audio values:
 */
#define YC_MIN_SAMPLE_RATE	5000	/* In Hz. */
#define YC_MIN_CHANNELS		1
#define YC_MIN_SAMPLE_SIZE	8	/* In bits. */
#define YC_MIN_FRAGMENT_SIZE	256	/* In bytes. */




#endif	/* CONFIG_H */
