#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "../include/Y2/Y.h"
#include "../include/Y2/Ylib.h"


int main(int argc, char *argv[])
{
	YConnection *con;
	char *filename;
	YEventSoundObjectAttributes sndobj_attrib;
	YID play_id;
	YEvent event;


	/* Need atleast one argument, being the file name.
	 * This is so that we can play a sound object on file.
	 */
	if(argc < 2)
		return(1);
	else
		filename = argv[1];


	/* Connect to the Y server. We pass NULL as the start argument,
	 * this means the Y server will not be started if it was not
	 * running. The connection argument is also NULL, which implies
	 * to connect to "127.0.0.1:9433" (the default address and port)
	 * or to the address and port specified by the enviroment
	 * variable RECORDER (if it is set).
	 *
	 * The connection argument is usually a string of the format
	 * "<address>:<port>", the <address> needs to be in IP ('numbers
	 * and dots') notation.
	 */
	con = YOpenConnection(
		NULL,
		NULL
	);
	if(con == NULL)
	{
		/* Connect failed. */
		fprintf(stderr, "Cannot connect to Y server.\n");
		return(1);
	}


	/* Let's check if the filename exists on the computer
	 * that the Y server is running on (think about that!) and
	 * obtain its attributes.
	 */

        if(YGetSoundObjectAttributes(
		con,
		filename,
		&sndobj_attrib
        ))
	{
		/* Can't get sound object attributes. */
		fprintf(
			stderr,
			"%s: Error: Missing or corrupt.\n",
			filename
		);
	}
	else
	{
		/* Start playing the sound object. */
		play_id = YStartPlaySoundObjectSimple(
			con,
                        filename
		);

		/* Print sound object attributes. */
		switch(sndobj_attrib.format)
                {
			case SndObjTypeDSP:
			printf(
"ID: %ld  Type: DSP  SmpRate: %i Hz  Bits: %i  Ch: %i\n",
                            play_id,
                            sndobj_attrib.sample_rate,
                            sndobj_attrib.sample_size,
                            sndobj_attrib.channels
                        );
                        break;

                        case SndObjTypeMIDI:
                        printf(
 "ID: %ld  Type: MIDI\n",
                            play_id
                        );
                        break;

                        default:
                        printf(
 "ID: %ld  Type: *Unknown*\n",
                            play_id
                        );
                }

		/* Wait untill audio is done playing. */
		while(1)
		{
			if(YGetNextEvent(
				con,
				&event,
				False	/* Nonblocking. */
		    	) > 0)
		    	{
	                	if((event.type == YSoundObjectKill) &&
			           (event.kill.yid == play_id)
			        )
				{
			        	/* Our play has stopped. */
					printf("Done playing.\n");
					break;
				}
				if((event.type == YDisconnect) ||
                                   (event.type == YShutdown)
				)
				{
					/* We got disconnect from Y server. */
					printf("Y server disconnected us.\n");

					YCloseConnection(con, False);
					con = NULL;
					break;
				}
			}

			usleep(1000);	/* Don't hog the CPU. */
		}
	}


	/* Disconnect from the Y server. We need to pass the original
	 * connection pointer con to close that connection to the Y server.
	 * The second argument asks us do we want to leave the Y server up
	 * when we disconnect. If we were the program that started the Y server
	 * and the second argument is set to False then the Y server
	 * will be automatically shut down.  To ensure that the Y server
	 * stays running, you can pass True instead.
	 */
	YCloseConnection(con, False);
	con = NULL;


	return(0);
}
