
#include "yodl.h"

void
gnu_vmessage (char const* format, va_list args)
{
  fprintf (stderr, "%s: %d: ", cur_input_file, cur_lineno);
  vfprintf (stderr, format, args);
  fprintf (stderr, "\n");
}

void
gnu_message (char const* format, ...)
{
  va_list args;
  va_start (args, format);
  gnu_vmessage (format, args);
  va_end (args);
}

void
gnu_vwarning (char const* format, va_list args)
{
  fprintf (stderr, "%s: %d: warning:", cur_input_file, cur_lineno);
  vfprintf (stderr, format, args);
  fprintf (stderr, "\n");
}

void
gnu_warning (char const* format, ...)
{
  va_list args;
  va_start (args, format);
  gnu_vwarning (format, args);
  va_end (args);
}

