static char *base64 =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static struct {
  int r_shift;
  int l_shift;
  int mask;
  } rlm[3]={{2,4,0x30}, {4,2,0x3c}, {6,0,0x3f}};

void mime_encode( unsigned char *sptr, unsigned char *dptr, int pslen )
{ int           mod3;
  unsigned char c;

  for( *dptr = c = mod3 = 0; pslen; pslen-- ){
    *dptr++ = base64[ c + ((*sptr) >> rlm[mod3].r_shift) ];
    c = (( *sptr++ ) << rlm[mod3].l_shift ) & rlm[ mod3 ].mask;
    if( mod3 == 2 ) {
      *dptr++ = base64[ c ];
      c = 0;
      mod3 = 0;
    } else {
      mod3++;
    }
  }
  if( mod3 ){
    *dptr++ = base64[ c ];
  }
  *dptr = 0;
}
    
    
