#ifndef _YYDECODE_H
#define _YYDECODE_H 1

#define lenof(str) (sizeof(str) - sizeof(char))

#define YMARKER_BEGIN	"=ybegin "
#define YMARKER_PART	"=ypart "
#define YMARKER_END	"=yend "

#define YTAG_PART	" part="
#define YTAG_TOTAL	" total="
#define YTAG_LINE	" line="
#define YTAG_SIZE	" size="
#define YTAG_NAME	" name="
#define YTAG_BEGIN	" begin="
#define YTAG_END	" end="
#define YTAG_PCRC32	" pcrc32="
#define YTAG_CRC32	" crc32="

#define YYDEC_BROKEN_SUFFIX	".broken"

/* 8MB for each part */
#define PART_SIZE_SOFT_LIMIT	(1 << 23)

/* EXIT_SUCCESS = 0, EXIT_FAILURE = 1 */
#define EXIT_WARNING	2
#define EXIT_EOF	3

enum part_status
{
	part_missing = 0,
	part_intact,
	part_duplicated,
	part_broken
};

struct decoded_file
{
	struct decoded_file *next;
	char *filename;
	int previously_existed;
	off_t total_size;
	off_t bytes_written;
	int total_parts;
	enum part_status *status;

	/* TODO: How shall we actually check the file CRC without making
	 * another pass over it? */

	/*struct crc32_ctx crc32_context;*/
	u_int32_t crc32;
};

#endif /* _YYDECODE_H */

