/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import Ice.RoutingTable;

public final class RouterInfo {
    private RouterPrx _router;
    private ObjectPrx _clientProxy;
    private ObjectPrx _serverProxy;
    private RoutingTable _routingTable;
    private ObjectAdapter _adapter;

    RouterInfo(RouterPrx routerPrx) {
        this._router = routerPrx;
        this._routingTable = new RoutingTable();
    }

    public synchronized void destroy() {
        this._clientProxy = null;
        this._serverProxy = null;
        this._adapter = null;
        this._routingTable.clear();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        RouterInfo routerInfo = null;
        try {
            routerInfo = (RouterInfo)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this._router.equals(routerInfo._router);
    }

    public synchronized ObjectPrx getClientProxy() {
        if (this._clientProxy == null) {
            this._clientProxy = this._router.getClientProxy();
            if (this._clientProxy == null) {
                throw new NoEndpointException();
            }
            this._clientProxy = this._clientProxy.ice_router(null);
            this._clientProxy = this._clientProxy.ice_timeout(this._router.ice_connection().timeout());
        }
        return this._clientProxy;
    }

    public ObjectPrx getServerProxy() {
        if (this._serverProxy == null) {
            this._serverProxy = this._router.getServerProxy();
            if (this._serverProxy == null) {
                throw new NoEndpointException();
            }
            this._serverProxy = this._serverProxy.ice_router(null);
        }
        return this._serverProxy;
    }

    public void addProxy(ObjectPrx objectPrx) {
        if (this._routingTable.add(objectPrx)) {
            this._router.addProxy(objectPrx);
        }
    }

    public synchronized void setAdapter(ObjectAdapter objectAdapter) {
        this._adapter = objectAdapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }
}

