/*____________________________________________________________________________

    Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

    Portions Copyright (C) 1999-2000 EMusic.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: xosdui.cpp,v 1.2 2004/01/07 21:58:02 kgk Exp $
____________________________________________________________________________*/

#include "eventdata.h"
//#include "player.h"
#include "pmo.h"
#include "preferences.h"
#include "xosdui.h"
#include <xosd.h>
#include <algorithm>
#include <iostream>

using namespace std;

extern "C" {

UserInterface *Initialize(FAContext *context) {
    return new XOSDUI(context);
}
           }

XOSDUI::XOSDUI(FAContext *context)
{
    m_context = context;
}

XOSDUI::~XOSDUI()
{
}

Error XOSDUI::Init(int32_t startup_level) 
{
    if ((m_startupType = startup_level) != SECONDARY_UI_STARTUP) {
        cout << _("The xosdui shouldn't run as the primary ui\n"); 
        return kError_InitFailedSafely;
    }

    if (!getenv("DISPLAY"))
        return kError_InitFailedSafely;

    m_playerEQ = m_context->target;
    m_xosd = xosd_create(1);
    loadprefs();
    xosd_display (m_xosd, 0, XOSD_string, "Welcome to Zinf!");
    return kError_NoErr;
}

Error XOSDUI::AcceptEvent(Event *event)
{
	switch (event->Type()) {
	case CMD_Cleanup: {
		xosd_destroy (m_xosd);
		//cleanup
		m_playerEQ->AcceptEvent(new Event(INFO_ReadyToDieUI));
		break; }
        case INFO_PrefsChanged: {
		loadprefs();
		break; }
	case INFO_Paused: {
		xosd_display (m_xosd, 0, XOSD_string, "Pause");
		break; }
        case INFO_Stopped: {
		xosd_display (m_xosd, 0, XOSD_string, "Stop");
		break; }
//        case CMD_EditCurrentPlaylistItemInfo:
	case INFO_StreamInfo: {
		StreamInfoEvent *pInfo=(StreamInfoEvent *) event;
		string msgText(pInfo->m_streamTitle);
		if (m_lastmsg != msgText){
			xosd_display (m_xosd, 0, XOSD_string, msgText.c_str());
			m_lastmsg=msgText;
		}
		break ;}
        case INFO_PlaylistCurrentItemInfo:
        case INFO_Playing:{
		string msgText="";
		PlaylistItem* pItem=m_context->plm->GetCurrentItem();
		if (pItem->GetMetaData().Title().length() > 0)
		{
			msgText = pItem->GetMetaData().Title();
		}
		if (pItem->GetMetaData().Artist().length() > 0)
		{
			msgText += " - " + pItem->GetMetaData().Artist();
		}
		if (pItem->GetMetaData().Album().length() > 0)
		{
			msgText += " " + pItem->GetMetaData().Album();
		}
		if (m_lastmsg != msgText){
			xosd_display (m_xosd, 0, XOSD_string, msgText.c_str());
			m_lastmsg=msgText;
		}
		break;}
 	case CMD_SetVolume:
 	case INFO_VolumeInfo:{
	  //This doesn't seem to be a "the playback volume changed" event
	  // 		xosd_display (m_xosd, 0, XOSD_slider, 37);
 		break; }
	case INFO_MediaTimeInfo:{
	  //Maybe one day?
	  break;
	}
        default:
            break;
    }
    return kError_NoErr;
}

void XOSDUI::loadprefs(){


  string font;
  string colour;
  int timeout=6;
  int voffset=8;
  int hoffset=8;

  if(m_context->prefs->GetPrefString("OSDFont",&font)==kError_NoPrefValue){
    font="-*-helvetica-bold-r-*-*-32-*-*-*-*-*-*-*";
    m_context->prefs->SetPrefString("OSDFont",font);  
  };
  if(m_context->prefs->GetPrefString("OSDColour",&colour)==kError_NoPrefValue){
    colour="Red";
    m_context->prefs->SetPrefString("OSDColour",colour);
  };
  m_context->prefs->GetPrefInt32("OSDTimeout", &timeout);
  if(timeout<0 || timeout>60){
    timeout=3;
    m_context->prefs->SetPrefInt32("OSDTimeout",timeout);
  }
  m_context->prefs->GetPrefInt32("OSDHoffset", &voffset);
  m_context->prefs->GetPrefInt32("OSDVoffset", &hoffset);
  if (voffset<0){
    voffset=8;
    m_context->prefs->SetPrefInt32("OSDVoffset",voffset);
  }
  if (hoffset<0){
    hoffset=8;
    m_context->prefs->SetPrefInt32("OSDHoffset",hoffset);
  }

  xosd_set_font(m_xosd, font.c_str());
  xosd_set_colour(m_xosd, colour.c_str());
  xosd_set_timeout(m_xosd, timeout);
  xosd_set_horizontal_offset(m_xosd, hoffset);
  xosd_set_vertical_offset(m_xosd, voffset);

  //hard-code these values
  xosd_set_shadow_offset(m_xosd, 3);
  xosd_set_pos(m_xosd,XOSD_bottom);
  xosd_set_align(m_xosd,XOSD_left);
}

// arch-tag: c4903e61-4d2c-49f1-8397-8906cce94751
