#!/usr/bin/python

# TODO: change this script to take a path to a Zope home directory
# when Zope 2.5 comes out and includes Page Templates by default.

import sys
import os.path
import glob
from string import strip, replace
import re

if not sys.argv[1:]:
    print """
Usage: appendix_c.py <path>

Builds 'AppendixC.stx' by locating Page Templates reference
information in a PageTemplates directory. The argument should be the
path to a PageTemplates package directory.

"""
    sys.exit(1)
dir=sys.argv[1]
if not os.path.isdir(dir):
    print "Path should be a path to your PageTemplates directory"
    sys.exit(1)

f=open('AppendixC.stx', 'wb')
f.write("""\
Appendix C: Zope Page Templates Reference

  Zope Page Templates are an HTML/XML generation tool. This appendix
  is a reference to Zope Page Templates standards: Tag Attribute
  Language (TAL), TAL Expression Syntax (TALES), and Macro Expansion
  TAL (METAL).

""")

link=re.compile(r'"([^"]+)":\S+\.(stx|py)([\s\.,:;\n])')

tal_files=glob.glob(os.path.join(dir, 'help/tal-*.stx'))
tal_files.sort()
tal_files.insert(0, os.path.join(dir, 'help/tal.stx'))

tales_files=glob.glob(os.path.join(dir, 'help/tales-*.stx'))
tales_files.sort()
tales_files.insert(0, os.path.join(dir, 'help/tales.stx'))

metal_files=glob.glob(os.path.join(dir, 'help/metal-*.stx'))
metal_files.sort()
metal_files.insert(0, os.path.join(dir, 'help/metal.stx'))

for file in tal_files + tales_files + metal_files:
    s=open(file, 'rb').read()
    # fix intra-tag links
    while 1:
        m=link.search(s)
        if m is None:
            break
        s=s[:m.start()] + m.group(1) + m.group(3) + s[m.end():]
    s=strip(s)
    s=replace(s, '\n', '\n  ')
    f.write('  ')
    f.write(s)
    f.write('\n\n')
f.close()
print "Wrote AppendixC.stx"
