#!/usr/bin/python
import sys
import os.path
import re
from StructuredText import HTMLWithImages, DocumentWithImages, Basic

if not sys.argv[1:]:
    print """
Usage: dtml.py <file.stx>...

Converts one or more structured text (.stx) files to dtml files. The
dtml files include standard headers and footers and include document
title information.
"""

title_pat=re.compile(r'<title>(.*?)</title>')
body_pat=re.compile(r'<body.*?>(.+)</body>', re.DOTALL)

for filename in sys.argv[1:]:
    htmlfile="%s.dtml" % os.path.splitext(filename)[0]
    print "%s -> %s" % (filename, htmlfile)
    f=open(htmlfile, 'wb')
    c=str(HTMLWithImages(DocumentWithImages(Basic(open(filename).read()))))
    m=title_pat.search(c)
    if m is not None:
       f.write("""<dtml-call expr="REQUEST.set('title', '%s')">""" % m.group(1))
    f.write('<dtml-var standard_html_header>\n')
    m=body_pat.search(c)
    if m is not None:
       f.write(m.group(1))
    f.write('\n<dtml-var standard_html_footer>')
    f.close()

            

