#!/usr/bin/python
import sys
import os
from ftplib import FTP
from glob import glob
from getpass import getpass

if not sys.argv[1:]:
    print """
Usage: upload.py <username>

Uploads the Book in DTML format to Zope.org given a username and
password.

Make sure you first build the DTML files with the dtml.py script.
"""
    sys.exit(1)
    
username=sys.argv[1]
password=getpass()

print "Connecting"
ftp=FTP('ftp.zope.org', username, password)
ftp.set_pasv(1)

ftp.cwd('/Members/michel/ZB')
for file in glob('*.dtml'):
    print "Uploading %s" % file
    f=open(file, 'rb')
    ftp.storbinary('STOR %s' % file, f, 1024)
    f.close()
    
ftp.cwd('/Members/michel/ZB/Figures')
os.chdir('Figures')
for file in glob('*.png'):
    print "Uploading %s" % file
    f=open(file, 'rb')
    ftp.storbinary('STOR %s' % file, f, 1024)
    f.close()

print "Closing"    
ftp.quit()
            









