## Script (Python) "switchLanguage"
##title=
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=set_language=None
REQUEST=context.REQUEST

lang = None
if set_language: lang=set_language

try: referrer=REQUEST.environ['HTTP_REFERER']
except: referrer=context.absolute_url()

# Use current context if we don't find a translation
obj = context

# Try to look up the translation
if context.isTranslatable() and context.isTranslation() and lang:
    translation = context.getTranslation(lang)
    if translation and context.portal_membership.checkPermission('View', translation):
        obj = translation

redirect = obj.absolute_url()

# Make sure we get everything including template and query variables
if referrer != redirect:
    tail = referrer[len(context.absolute_url()):]
    if tail.find('?') != -1:
        tail = tail[:tail.index('?')]
    redirect += tail

query={}
# parse current query
s = referrer.find('?')
if s >= 0:
    q = referrer[s+1:]
    referrer=referrer[:s]
    for e in q.split("&"):
        if e:
            k,v = e.split("=")
            query[k]=v

if lang:
    # no cookie support
    query['cl']=lang

if set_language:
    query['set_language']=lang

qst="?"
for k, v in query.items():
    qst=qst+"%s=%s&" % (k, v)

redirect=redirect+qst[:-1]

REQUEST.RESPONSE.redirect(redirect)
