/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: packet.c,v 1.6 2003/10/22 09:53:32 bazsi Exp $
 *
 * Author  : SaSa
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/packet.h>
#include <zorp/log.h>

#include <string.h>

/**
 * z_packet_new:
 *
 * Create a new ZPacket instance, set its length to 0 and its data ptr to NULL
 *
 * Returns: ZPacket* pointer to the new instance
 */
ZPacket *
z_packet_new(void)
{
  ZPacket *pack;

  z_enter();
  pack = g_new0(ZPacket, 1);
  z_leave();
    
  return pack;
}

/**
 * z_packet_set_data:
 * @p 'this'
 * @data pointer to the data block
 * @length length of the data block
 *
 * Set the data/length fields of p to the specified data block
 * !!! HINT: If this function is called multiple times, memory leak could
 *     occur since there is no check on whether p->data is already set.
 *     Certainly, if there is another reference to the old value of p->data,
 *     then this is not a problem, so this may be intentional, depends on the
 *     semantics used for handling these buffers. !!!
 */
void
z_packet_set_data(ZPacket *p, const guchar *data, guint length)
{
  p->length = length;
  p->data = g_malloc(length);
  memcpy(p->data, data, length);
}

/**
 * z_packet_free:
 * @p 'this'
 *
 * Destructor, deallocates the buffer if present, then the instance itself.
 */
void 
z_packet_free(ZPacket *p)
{
  z_enter();
  
  if (p->data != NULL)
    g_free(p->data);

  g_free(p);
  z_leave();
}
