/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: anypy.c,v 1.28 2003/10/13 09:40:54 bazsi Exp $
 *
 * Author: Bazsi
 * Auditor: Bazsi
 * Last audited version: 1.14
 * Notes:
 *
 ***************************************************************************/
 
#include <zorp/zorp.h>
#include <zorp/proxy.h>
#include <zorp/thread.h>
#include <zorp/policy.h>
#include <zorp/zpython.h>
#include <zorp/pystream.h>
#include <zorp/registry.h>
#include <zorp/log.h>

typedef struct _AnyPyProxy
{
  ZProxy super;
} AnyPyProxy;

extern ZClass AnyPyProxy__class;

static void
anypy_main(ZProxy * s)
{
  AnyPyProxy *self = Z_CAST(s, AnyPyProxy);
  ZPolicyObj *res;
  gboolean called;
  
  z_proxy_enter(self);
  z_policy_lock(self->super.thread);  
  res = z_policy_call(self->super.handler, "proxyThread", NULL, &called, self->super.session_id);
  z_policy_var_unref(res);
  z_policy_unlock(self->super.thread);
  z_proxy_leave(self);
}

ZProxy *
anypy_proxy_new(ZProxyParams *params)
{
  AnyPyProxy *self;
  
  z_enter();
  self = Z_CAST(z_proxy_new(Z_CLASS(AnyPyProxy), params), AnyPyProxy);
  
  z_proxy_start(&self->super);
  z_leave();
  return &self->super;
}

ZProxyFuncs anypy_proxy_funcs =
{
  {
    Z_FUNCS_COUNT(ZProxy),
    NULL
  },
  NULL,
  NULL,
  anypy_main,
  NULL,
  NULL,
  NULL
};

ZClass AnyPyProxy__class =
{
  Z_CLASS_HEADER,
  &ZProxy__class,
  "AnyPyProxy",
  sizeof(AnyPyProxy),
  &anypy_proxy_funcs.super,
};

gint
zorp_module_init(void)
{
  z_registry_add("anypy", ZR_PYPROXY, anypy_proxy_new);
  return TRUE;
}
