/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/
#pragma prototyped

#include                "render.h"
#include                "gd.h"

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#define         NONE            0
#define         NODE            1
#define         EDGE            2
#define         CLST            3

/* IMAP font modifiers */
#define REGULAR 0
#define BOLD            1
#define ITALIC          2

/* IMAP patterns */
#define P_SOLID         0
#define P_NONE  15
#define P_DOTTED 4                              /* i wasn't sure about this */
#define P_DASHED 11                             /* or this */

#define SCALE (GD_RESOLUTION/72.0)

/* IMAP bold line constant */
#define WIDTH_NORMAL 1
#define WIDTH_BOLD 3

static FILE     *Outfile;
/* static int        Obj; */
/* static int        N_pages; */
/* static point    Pages; */
static double   Scale;
static pointf   Offset;
static int        Rot;
static box        PB;
static int        onetime = TRUE;

typedef struct context_t {
	char                    color_ix, *fontfam, fontopt, font_was_set;
	char                    pen, fill, penwidth, style_was_set;
	float              fontsz;
} context_t;

#define MAXNEST 4
static context_t cstk[MAXNEST];
static int        SP;

static  void
imap_reset(void)
{
	onetime = TRUE;
}

static  void
init_imap(void)
{
	SP = 0;
	cstk[0].color_ix = 0;           /* IMAP color index 0-7 */
	cstk[0].fontfam = "Times";              /* font family name */
	cstk[0].fontopt = REGULAR;              /* modifier: REGULAR, BOLD or ITALIC */
	cstk[0].pen = P_SOLID;          /* pen pattern style, default is sold */
	cstk[0].fill = P_NONE;
	cstk[0].penwidth = WIDTH_NORMAL;
}

static            pointf
imappt(pointf p)
{
	pointf            tmp, rv;
	tmp.x = p.x * Scale;
	tmp.y = Scale * p.y;
	if (Rot == 0) {
		rv.x = tmp.x + Offset.x;
		rv.y = PB.UR.y - PB.LL.y - tmp.y + Offset.y;
	} else {
		rv.x = PB.UR.x - PB.LL.x - tmp.y + Offset.x;
                rv.y = PB.UR.y - PB.LL.y - tmp.x + Offset.y;
	}
	return rv;
}

static  void
imap_font(context_t* cp)
{
}

static  void
imap_color(int i)
{
}

static  void
imap_style(context_t* cp)
{
}

static void
imap_begin_job(FILE *ofp, graph_t *g, char **lib, char *user, char *info[], point pages)
{
	Outfile = ofp;
	/* Pages = pages; */
	/* N_pages = pages.x * pages.y; */
	fprintf(Outfile,"# Generated by %s version %s (%s)\n", info[0],info[1],info[2]);
	fprintf(Outfile,"base referer\n");
}

static void
imap_end_job(void)
{
}

static void
imap_begin_graph(graph_t* g, box bb, point pb)
{
	char               *s;

	g = g;
	PB.LL.x = bb.LL.x * SCALE;
	PB.LL.y = bb.LL.y * SCALE;
	PB.UR.x = bb.UR.x * SCALE;
	PB.UR.y = bb.UR.y * SCALE;
	Offset.x = PB.LL.x + 1;
	Offset.y = PB.LL.y + 1;
	if (onetime) {
		init_imap();
		onetime = FALSE;
	}
	if ((s = agget(g, "URL")) && strlen(s)) fprintf(Outfile,"default %s\n",s);
}

static void
imap_end_graph(void)
{
}

static  void
imap_begin_page(point page, double scale, int rot, point offset)
{
	/* int                      page_number; */
	/* point              sz; */

	Scale = scale * SCALE;
	Rot = rot;
	/* page_number = page.x + page.y * Pages.x + 1; */
	/* sz = sub_points(PB.UR, PB.LL); */
}

static  void
imap_end_page(void)
{
}

static  void
imap_begin_cluster(graph_t* g)
{
	/* Obj = CLST; */
}

static  void
imap_end_cluster(void)
{
	/* Obj = NONE; */
}

static void imap_begin_nodes(void) { }

static void imap_end_nodes(void) { }

static void imap_begin_edges(void) { }

static void imap_end_edges(void) { }


static  void
imap_begin_node(node_t* n)
{
	char               *s,*s1,*s2,*sn;
	pointf                  p,p1,p2;

	/* Obj = NODE; */
	if ((s = agget(n, "URL")) && strlen(s)) {
		p.x = n->u.coord.x - n->u.lw;
		p.y = n->u.coord.y - (n->u.ht/2);
		p1 = imappt(p);
		p.x = n->u.coord.x + n->u.rw;
		p.y = n->u.coord.y + (n->u.ht/2);
		p2 = imappt(p);

		s = strdup(s);
		sn = n->name;
		if ((s2 = strstr(s,NODENAME_ESC))) {
			s1 = n->name;
			*s2 = '\0';
			s2 += 2;
		} else {
			s1 = s2 = "";
		}

		fprintf(Outfile,"# Rectangle for %s\n",sn);
		fprintf(Outfile,"rect %s%s%s %d,%d %d,%d\n",
			s,s1,s2,
			ROUND(p1.x),ROUND(p1.y),ROUND(p2.x),ROUND(p2.y));

		free(s);
	}
}

static  void
imap_end_node(void)
{
	/* Obj = NONE; */
}

static  void
imap_begin_edge(edge_t* e)
{
    char               *s, *sc;
    char               *sh,*sh1,*sh2,*shl;
    char               *st,*st1,*st2,*stl;
    pointf                  p,p1;
    bezier bz;
    int i,ish,ist,isc;

    /* Obj = EDGE; */

    sc = sh = st = 0;
    shl= sh1 = sh2 = stl = st1 = st2 = "";

    isc = 0;
    if ((s = agget(e, "URL")) && strlen(s))  {
	sc = strdup(s);
	isc = 1;
	if (e->u.spl) {
	    int i,j;

	    for (i = 0; i < e->u.spl->size; i++) {

		bz = e->u.spl->list[i];

		for (j = 0; j < bz.size; j +=3) {
		    if (((i == 0) && (j == 0))  /* origin */
		    ||  ((i == (e->u.spl->size -1)) && (j == (bz.size - 1)))
		    ) {
			continue;
		    }
		    p.x = bz.list[j].x;
		    p.y = bz.list[j].y;
		    p1 = imappt(p);
		    fprintf(Outfile,"# Edge %d spline %d point %d \n",
		    e->id, i, j);
		    fprintf(Outfile,"point %s %d,%d\n",
			s, ROUND(p1.x),ROUND(p1.y));
		}
	    }
	}
	if (e->u.label) {

	    /* I believe these to be the label center coords,
	       from libgraph code usage */
	    p.x = e->u.label->p.x;
	    p.y = e->u.label->p.y;
	    p1 = imappt(p);

	    fprintf(Outfile,"# Edge %d label\n",e->id);
	    fprintf(Outfile,"point %s %d,%d\n",
		s, ROUND(p1.x),ROUND(p1.y));
	}

    }

    /*  establish correct text for head and tail URL                    */

    ist = ish = 0;

    if (e->u.head_label) shl =  e->u.head_label->text;
    if (e->u.tail_label) stl =  e->u.tail_label->text;

    if ((s = agget(e, "headURL")) && strlen(s))  {
	sh = strdup(s);
	ish = 1;
	if ((sh2 = strstr(sh,NODENAME_ESC))) {
	    sh1 = shl;
	    *sh2 = '\0';
	    sh2 += 2;
	} else {
	    sh1 = sh2 = "";
	}
    }

    if ((s = agget(e, "tailURL")) && strlen(s))  {
	st = strdup(s);
	ist = 1;
	if ((st2 = strstr(st,NODENAME_ESC))) {
	    st1 = stl;
	    *st2 = '\0';
	    st2 += 2;
	} else {
	    st1 = st2 = "";
	}
     }

    /*  fprintf(stderr,"\tSurvived setting the strings\n");             */

    /*  Here's the end of the drawn line.  Does it have an arrow?       */
    /*  If it has an arrow at the end then it is the Head               */
    /*  If it is the Head then ep would be set.                         */

    i = e->u.spl->size-1;
    bz = e->u.spl->list[i];

    fprintf(Outfile,"# Edge %d last spline %d ", e->id, i);
    if (bz.eflag) {

	fprintf(Outfile,"has eflag ");

	p.x = bz.ep.x;
	p.y = bz.ep.y;
	p1 = imappt(p);
/*
	fprintf(stderr,"\tEdge %d found Arrow at End of Splines, must be Head\n",e->id);
*/
	if (ish) {
	    fprintf(Outfile,"head (%s) URL\n", shl);
	    fprintf(Outfile,"point %s%s%s %d,%d\n",
	    sh,sh1,sh2,
	    ROUND(p1.x),ROUND(p1.y));
	} else if (isc) {
	    fprintf(Outfile,"default to edge URL\n");
	    fprintf(Outfile,"point %s %d,%d\n",
	    sc, ROUND(p1.x),ROUND(p1.y));
	} else {
	    fprintf(Outfile,"no URL\n");
	}

    } else {

	if (bz.sflag) fprintf(Outfile,"*HAS SFLAG* ");

	/* isn't this the center of the node [sla]?  NO. [de] */

	p.x = bz.list[bz.size-1].x;
	p.y = bz.list[bz.size-1].y;
	p1 = imappt(p);
/*
	fprintf(stderr,"\tEdge %d found No Arrow at End of Splines, must be Tail\n",e->id);
*/
	if (ist) {
	    fprintf(Outfile,"tail (%s) URL\n", stl);
	    fprintf(Outfile,"point %s%s%s %d,%d\n",
	    st,st1,st2,
	    ROUND(p1.x),ROUND(p1.y));
	} else if (isc) {
	    fprintf(Outfile,"default to edge URL\n");
	    fprintf(Outfile,"point %s %d,%d\n",
	    sc, ROUND(p1.x),ROUND(p1.y));
	} else {
	    fprintf(Outfile,"no URL\n");
	}

    }

    /*  Here's the start of the drawn line.  Does it have an arrow?     */
    /*  If it has an arrow at the start, then it is the Head.           */
    /*  If it is the head then sp would be set.                         */

    bz = e->u.spl->list[0];

    fprintf(Outfile,"# Edge %d first spline 0 ", e->id);
    if (bz.sflag) {

	fprintf(Outfile,"has sflag ");

	p.x = bz.sp.x;
	p.y = bz.sp.y;
	p1 = imappt(p);
/*
	fprintf(stderr,"\tEdge %d found Arrow at Start of Splines, must be Head\n",e->id);
*/
	if (ish) {
	    fprintf(Outfile,"head (%s) URL\n", shl);
	    fprintf(Outfile,"point %s%s%s %d,%d\n",
	    sh,sh1,sh2,
	    ROUND(p1.x),ROUND(p1.y));
	} else if (isc) {
	    fprintf(Outfile,"default to edge URL\n");
	    fprintf(Outfile,"point %s %d,%d\n",
	    sc, ROUND(p1.x),ROUND(p1.y));
	} else {
	    fprintf(Outfile,"no URL\n");
	}

    } else {

	if (bz.eflag) fprintf(Outfile,"*HAS EFLAG* "); 

	/* isn't this the center of the node ? */
	p.x = bz.list[0].x;
	p.y = bz.list[0].y;
	p1 = imappt(p);
/*
	fprintf(stderr,"\tEdge %d found No Arrow at Start of Splines, must be Tail\n",e->id);
*/
	if (ist) {
	    fprintf(Outfile,"tail (%s) URL\n", stl);
	    fprintf(Outfile,"point %s%s%s %d,%d\n",
	    st,st1,st2,
	    ROUND(p1.x),ROUND(p1.y));
	} else if (isc) {
	    fprintf(Outfile,"default to edge URL\n");
	    fprintf(Outfile,"point %s %d,%d\n",
	    sc, ROUND(p1.x),ROUND(p1.y));
	} else {
	    fprintf(Outfile,"no URL\n");
	}
    }
    if (sc) free(sc);
    if (sh) free(sh);
    if (st) free(st);
}

static  void
imap_end_edge(void)
{
	/* Obj = NONE; */
}

static  void
imap_begin_context(void)
{
	assert(SP + 1 < MAXNEST);
	cstk[SP + 1] = cstk[SP];
	SP++;
}

static  void
imap_end_context(void)
{
	int                      c, psp = SP - 1;
	assert(SP > 0);
	if (cstk[SP].color_ix != (c = cstk[psp].color_ix))
		imap_color(c);
	if (cstk[SP].font_was_set)
		imap_font(&(cstk[psp]));
	if (cstk[SP].style_was_set)
		imap_style(&(cstk[psp]));
	/* free(cstk[psp].fontfam); */
	SP = psp;
}

static  void
imap_set_font(char* name, double size)
{
}

static  void
imap_set_color(char* name)
{
}

static  void
imap_set_style(char** s)
{
}

static  void
imap_textline(point p, textline_t *line)
{
}

static  void
imap_bezier(point* A, int n, int arrow_at_start, int arrow_at_end)
{
}

static  void
imap_polygon(point *A, int n, int filled)
{
	pointf            p, p0;
	int                      i;

	p0.x = A[0].x; p0.y = A[0].y;
	p0 = imappt(p0);
	p.x = p0.x; p.y = p0.y;
	for (i = 1; i < n; i++) {
		/* p1.x = p.x; p1.y = p.y; */
		p.x = A[i].x; p.y = A[i].y;
		p = imappt(p);
/*              gdImageLine(im, ROUND(p1.x), ROUND(p1.y),
			ROUND(p.x), ROUND(p.y), black); */
	}
/*      gdImageLine(im, ROUND(p.x), ROUND(p.y),
		ROUND(p0.x), ROUND(p0.y), black); */
}

static  void
imap_ellipse(point p, int rx, int ry, int filled)
{
	pointf            mp;

	mp.x = p.x; mp.y = p.y;
	mp = imappt(mp);
/*      gdImageArc(im, ROUND(mp.x), ROUND(mp.y),
		ROUND(Scale*(rx + rx)), ROUND(Scale*(ry + ry)), 0, 360, black); */
}

static  void
imap_polyline(point* A, int n)
{
	pointf            p, p1;
	int                      i;

	p.x = A[0].x;
	p.y = A[0].y;
	p = imappt(p);
	for (i = 1; i < n; i++) {
		p1.x = A[i].x;
		p1.y = A[i].y;
		p1 = imappt(p1);
/*              gdImageLine(im, ROUND(p.x), ROUND(p.y), ROUND(p1.x), ROUND(p1.y), black); */
		p.x = p1.x;
		p.y = p1.y;
	}
}

static  void
imap_user_shape(char *name, point *A,int  n, int filled)
{
	static boolean  onetime = TRUE;
	if (onetime) {
		fprintf(stderr, "custom shapes not available with this driver\n");
		onetime = FALSE;
	}
	imap_polygon(A, n, filled);
}

codegen_t       IMAP_CodeGen = {
	imap_reset,
	imap_begin_job, imap_end_job,
	imap_begin_graph, imap_end_graph,
	imap_begin_page, imap_end_page,
	imap_begin_cluster, imap_end_cluster,
	imap_begin_nodes, imap_end_nodes,
	imap_begin_edges, imap_end_edges,
	imap_begin_node, imap_end_node,
	imap_begin_edge, imap_end_edge,
	imap_begin_context, imap_end_context,
	imap_set_font, imap_textline,
	imap_set_color, imap_set_color, imap_set_style,
	imap_ellipse, imap_polygon,
	imap_bezier, imap_polyline,
	0 /* imap_arrowhead */, imap_user_shape,
	0 /* imap_comment */, gd_textsize
};

