/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.JideScrollPane;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.IGVMainFrame;

import javax.swing.*;
import java.awt.*;

/**
 * @author jrobinso
 */
public class TrackPanelScrollPane extends JideScrollPane {

    TrackPanel trackPanel;

    @Override
    public void setViewportView(Component trackSetView) {
        if (!(trackSetView instanceof TrackPanel)) {
            throw new IllegalArgumentException("Class TrackPanelScrollPane can only contain a TrackPanel");
        }
        super.setViewportView(trackSetView);
        this.trackPanel = (TrackPanel) trackSetView;
        this.verticalScrollBar.addAdjustmentListener(getNamePanel());
        init();
    }

    public TrackPanel getTrackPanel() {
        return trackPanel;
    }

    @Override
    public String getName() {
        return trackPanel.getName();
    }

    public void minimizeHeight() {
        int prefHeight = trackPanel.getPreferredPanelHeight();
        if (prefHeight < trackPanel.getViewportHeight()) {
            this.setSize(getWidth(), prefHeight);
        }
    }

    public DataPanel getDataPanel() {
        return trackPanel.getDataPanel();
    }

    public boolean isEmpty() {
        return !trackPanel.hasTracks();
    }

    public TrackNamePanel getNamePanel() {
        return trackPanel.getNamePanel();
    }

    public AttributePanel getAttributePanel() {
        return trackPanel.getAttributePanel();
    }

    public Dimension getPreferredSize() {
        //if (!tracksAreLoaded()) {
            return super.getPreferredSize();
        //} else {
        //    int prefWidth = super.getPreferredSize().width;
        //    int prefHeight = trackPanel.getPreferredPanelHeight();
        //    return new Dimension(prefWidth, prefHeight);
        //}
    }

    /**
     * TODO -- a hack, needed to override pref size on initial startup.
     *
     * @return
     */
    private boolean tracksAreLoaded() {
        return IGVMainFrame.getInstance().getTrackManager().getAllTracks(false).size() > 0;
    }

    private void init() {
        setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(102, 102, 102)));
        setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        setFocusTraversalPolicyProvider(true);
        setMinimumSize(new java.awt.Dimension(0, 0));
        setOpaque(false);
    }
}
