/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.peephole.ClassMerger;

public class RetargetedClassFilter
implements ClassVisitor {
    private final ClassVisitor retargetedClassVisitor;
    private final ClassVisitor otherClassVisitor;

    public RetargetedClassFilter(ClassVisitor classVisitor) {
        this(classVisitor, null);
    }

    public RetargetedClassFilter(ClassVisitor classVisitor, ClassVisitor classVisitor2) {
        this.retargetedClassVisitor = classVisitor;
        this.otherClassVisitor = classVisitor2;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = ClassMerger.getTargetClass(programClass) != null ? this.retargetedClassVisitor : this.otherClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.otherClassVisitor != null) {
            this.otherClassVisitor.visitLibraryClass(libraryClass);
        }
    }
}

