/* config.H
 * John Viega
 *
 * Jan 28-29 2000
 */

#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "vulninfo.H"
#include <stdlib.h>
#ifdef HAVE_UNISTD
#include <unistd.h>
#endif
#include <stdio.h>
#include <string.h>

#ifdef USE_ANSI
#define strcasecmp stricmp
#endif

#ifdef   _WIN32
#define  NEWLINE  "\r\n"
#else
#define  NEWLINE  "\n"
#endif

#define EX1(x)       #x
#define EX2(x)       EX1(x)
#define DB_FILE_NAME "vulns.i4d"
#define ITS4_VERSION "1.1.1"
#define VERSION_DATE "Oct 2, 2000"

FILE*    GetOutputFile();
int      GetUseHandlers();
void     ShowHelp();
void     GetVulnDBLocations(char *&, char *&);
int      GetShowSeverity();
int      GetArglessOkay();
int      ShowDescription();
int      ShowSolution();
int      GetOutputWidth();
int      GetSortType();
int      GetReverseSort();
int      GetInputScanning();
Severity GetSeverityCutoff();
int      GetMSVSFormat();
char     *GetProgramName();
void     SetProgramName(char *);
void     ParseOptions(int argc, char **argv, int& start_arg);
int      IgnoreIts4Commands();
int      Paranoid();

#endif
