/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.output;

import com.mentorgen.tools.profile.Controller;
import com.mentorgen.tools.profile.output.ClassAllocComparator;
import com.mentorgen.tools.profile.output.FrameComparator;
import com.mentorgen.tools.profile.output.FrameDump;
import com.mentorgen.tools.profile.output.Holder;
import com.mentorgen.tools.profile.output.HolderComparator;
import com.mentorgen.tools.profile.output.Math;
import com.mentorgen.tools.profile.runtime.ClassAllocation;
import com.mentorgen.tools.profile.runtime.Frame;
import com.mentorgen.tools.profile.runtime.Profile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

final class ProfileTextDump {
    static HashMap<String, Holder> _clumpedFrameMap;

    ProfileTextDump() {
    }

    static void dump() throws IOException {
        Appendable appendable;
        _clumpedFrameMap = new HashMap();
        String string = null;
        File file = new File(Controller._fileName);
        Date date = new Date();
        if (file.isDirectory()) {
            appendable = new StringBuffer(file.getAbsolutePath());
            ((StringBuffer)appendable).append(File.separator);
            ((StringBuffer)appendable).append(new SimpleDateFormat("yyyyMMdd-HHmmss").format(date));
            ((StringBuffer)appendable).append(".txt");
            string = ((StringBuffer)appendable).toString();
        } else if (Controller._fileName.endsWith(".txt")) {
            string = Controller._fileName;
        } else {
            appendable = new StringBuffer(Controller._fileName);
            ((StringBuffer)appendable).append(".txt");
            string = ((StringBuffer)appendable).toString();
        }
        appendable = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter((Writer)appendable);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        printWriter.println("+----------------------------------------------------------------------");
        printWriter.print("|  File: ");
        printWriter.println(string);
        printWriter.print("|  Date: ");
        printWriter.println(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss a").format(date));
        printWriter.println("+----------------------------------------------------------------------");
        printWriter.println();
        if (!Controller._outputSummaryOnly) {
            ProfileTextDump.dumpThreads(printWriter);
        }
        ProfileTextDump.dumpFrames(printWriter);
        ProfileTextDump.dumpClumpedFrames(printWriter);
        ProfileTextDump.dumpAllocation(printWriter);
        printWriter.flush();
        ((OutputStreamWriter)appendable).close();
    }

    private static void dumpThreads(PrintWriter printWriter) {
        printWriter.println("+------------------------------");
        printWriter.print("| Thread depth limit: ");
        if (Controller._compactThreadDepth) {
            printWriter.println("Compact");
        } else if (Controller._threadDepth == -1) {
            printWriter.println("Unlimited");
        } else {
            printWriter.println(Controller._threadDepth);
        }
        printWriter.println("+------------------------------");
        for (Long l : Profile.threads()) {
            int n = 1;
            for (Frame frame : Profile.interactions(l)) {
                FrameDump.dump(printWriter, frame, n);
                ++n;
            }
        }
    }

    private static void dumpFrames(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("+--------------------------------------");
        printWriter.println("| Most expensive methods (by net time)");
        printWriter.print("| Frame Count Limit: ");
        if (Controller._compactMethodCount) {
            printWriter.println("Compact");
        } else if (Controller._methodCount == -1) {
            printWriter.println("Unlimited");
        } else {
            printWriter.println(Controller._methodCount);
        }
        printWriter.println("+--------------------------------------");
        printWriter.println();
        printWriter.println("               Net");
        printWriter.println("          ------------");
        printWriter.println(" Count     Time    Pct  Location");
        printWriter.println(" =====     ====    ===  ========");
        int n = 0;
        boolean bl = true;
        Profile.sortFrameList(new FrameComparator());
        for (Frame frame : Profile.frameList()) {
            long l = frame.getThreadId();
            double d = Profile.getThreadTotalTime(l);
            double d2 = Math.toPercent(frame.netTime(), d);
            double d3 = Math.nanoToMilli(frame.netTime());
            String string = frame.getName();
            if (bl && ProfileTextDump.belowThreshold(d3, n)) {
                bl = false;
            }
            ++n;
            if (bl) {
                printWriter.printf("%6d ", frame._metrics.getCount());
                printWriter.printf("%8.1f  ", d3);
                printWriter.printf("%5.1f  ", d2);
                printWriter.println(string);
            }
            ProfileTextDump.clumpFrame(frame._metrics.getCount(), d3, d2, string);
        }
    }

    private static void clumpFrame(long l, double d, double d2, String string) {
        Holder holder = _clumpedFrameMap.get(string);
        if (holder == null) {
            holder = new Holder(l, d, d2, string);
            _clumpedFrameMap.put(string, holder);
        } else {
            holder._count += l;
            holder._time += d;
            holder._percent += d2;
        }
    }

    private static void dumpClumpedFrames(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("+--------------------------------------+");
        printWriter.println("| Most expensive methods summarized    |");
        printWriter.println("+--------------------------------------+");
        printWriter.println();
        LinkedList<Holder> linkedList = new LinkedList<Holder>();
        for (Holder holder : _clumpedFrameMap.values()) {
            linkedList.add(holder);
        }
        Collections.sort(linkedList, new HolderComparator());
        printWriter.println("               Net");
        printWriter.println("          ------------");
        printWriter.println(" Count     Time    Pct  Location");
        printWriter.println(" =====     ====    ===  ========");
        long l = 0L;
        for (Holder holder : linkedList) {
            if (ProfileTextDump.belowThreshold(holder._time, l)) break;
            ++l;
            printWriter.printf("%6d ", holder._count);
            printWriter.printf("%8.1f  ", holder._time);
            printWriter.printf("%5.1f  ", holder._percent);
            printWriter.println(holder._name);
        }
    }

    private static boolean belowThreshold(double d, long l) {
        return Controller._compactMethodCount ? d < (double)Controller._compactMethodThreshold : Controller._methodCount != -1 && l + 1L == (long)Controller._methodCount;
    }

    private static void dumpAllocation(PrintWriter printWriter) {
        if (!Controller._trackObjectAlloc) {
            return;
        }
        printWriter.println();
        printWriter.println("+---------------------------------+");
        printWriter.println("| Object Allocation               |");
        printWriter.println("+---------------------------------+");
        printWriter.println();
        printWriter.println("     Count Class Name");
        printWriter.println("     ===== ==========");
        LinkedList<ClassAllocation> linkedList = new LinkedList<ClassAllocation>();
        for (ClassAllocation classAllocation : Profile.allocations()) {
            linkedList.add(classAllocation);
        }
        Collections.sort(linkedList, new ClassAllocComparator());
        for (ClassAllocation classAllocation : linkedList) {
            printWriter.printf("%10d  ", classAllocation.getAllocCount());
            printWriter.println(classAllocation.getClassName());
        }
    }
}

