/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RMISecurityException;
import java.rmi.server.RMIClassLoader;

public class RMISecurityManager
extends SecurityManager {
    private boolean inStub() {
        return this.inClassLoader();
    }

    public Object getSecurityContext() {
        return RMIClassLoader.getSecurityContext(this.currentClassLoader());
    }

    public synchronized void checkCreateClassLoader() {
        if (this.inStub()) {
            throw new RMISecurityException("classloader");
        }
    }

    public synchronized void checkAccess(Thread thread) {
        if (this.inStub()) {
            throw new RMISecurityException("thread");
        }
    }

    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.inStub()) {
            throw new RMISecurityException("threadgroup");
        }
    }

    public synchronized void checkExit(int n) {
        if (this.inStub()) {
            throw new RMISecurityException("exit", String.valueOf(n));
        }
    }

    public synchronized void checkExec(String string) {
        if (this.inStub()) {
            throw new RMISecurityException("exec", string);
        }
    }

    public synchronized void checkLink(String string) {
        switch (this.classLoaderDepth()) {
            case 2: 
            case 3: {
                throw new RMISecurityException("link", string);
            }
        }
    }

    public synchronized void checkPropertiesAccess() {
        if (this.classLoaderDepth() == 2) {
            throw new RMISecurityException("properties");
        }
    }

    public synchronized void checkPropertyAccess(String string) {
        if (this.classLoaderDepth() == 2 && !"true".equalsIgnoreCase(System.getProperty(String.valueOf(string) + ".rmi"))) {
            throw new RMISecurityException("properties");
        }
    }

    public synchronized void checkRead(String string) {
        if (this.inStub()) {
            throw new RMISecurityException("file.read", string);
        }
    }

    public void checkRead(String string, Object object) {
        if (this.inStub()) {
            throw new RMISecurityException("file.read", string);
        }
    }

    public synchronized void checkWrite(String string) {
        if (this.inStub()) {
            throw new RMISecurityException("file.write", string);
        }
    }

    public void checkDelete(String string) {
        if (this.inStub()) {
            throw new RMISecurityException("file.delete", string);
        }
    }

    public synchronized void checkRead(FileDescriptor fileDescriptor) {
        if (this.inStub() && !this.inClass("java.net.SocketInputStream") || !fileDescriptor.valid()) {
            throw new RMISecurityException("fd.read");
        }
    }

    public synchronized void checkWrite(FileDescriptor fileDescriptor) {
        if (this.inStub() && !this.inClass("java.net.SocketOutputStream") || !fileDescriptor.valid()) {
            throw new RMISecurityException("fd.write");
        }
    }

    public synchronized void checkListen(int n) {
        if (this.inStub()) {
            throw new RMISecurityException("socket.listen", String.valueOf(n));
        }
    }

    public synchronized void checkAccept(String string, int n) {
        if (this.inStub()) {
            throw new RMISecurityException("socket.accept", String.valueOf(string) + ":" + String.valueOf(n));
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        if (this.inStub()) {
            throw new RMISecurityException("checkmulticast");
        }
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        if (this.inStub()) {
            throw new RMISecurityException("checkmulticast");
        }
    }

    public synchronized void checkConnect(String string, int n) {
        if (!this.inStub()) {
            return;
        }
        int n2 = this.classDepth("sun.rmi.transport.tcp.TCPChannel");
        if (n2 > 1) {
            return;
        }
        Object object = this.getSecurityContext();
        if (object != null && object instanceof URL) {
            this.checkConnect(((URL)object).getHost(), string);
            return;
        }
        throw new RMISecurityException("checkConnect", "To " + string + ":" + n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void checkConnect(String string, String string2) {
        try {
            this.inCheck = true;
            if (!string.equals(string2)) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string2);
                    InetAddress inetAddress2 = InetAddress.getByName(string);
                    if (!inetAddress2.equals(inetAddress)) throw new RMISecurityException("checkConnect", "To " + string2);
                    Object var4_6 = null;
                    this.inCheck = false;
                    return;
                }
                catch (UnknownHostException unknownHostException) {
                    throw new RMISecurityException("checkConnect", "To " + string2);
                }
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RMISecurityException("checkConnect", "To " + string2);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.inCheck = false;
            throw throwable;
        }
        Object var4_7 = null;
        this.inCheck = false;
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n);
        if (object != null) {
            if (object instanceof URL) {
                this.checkConnect(((URL)object).getHost(), string);
                return;
            }
            throw new RMISecurityException("checkConnect (unknown context)", "To " + string);
        }
    }

    public synchronized boolean checkTopLevelWindow(Object object) {
        return !this.inStub();
    }

    public synchronized void checkPackageAccess(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (this.inClassLoader() && Boolean.getBoolean("package.restrict.access." + string)) {
            throw new SecurityException();
        }
    }

    public synchronized void checkPackageDefinition(String string) {
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (this.inClassLoader() && Boolean.getBoolean("package.restrict.definition." + string)) {
            throw new SecurityException();
        }
    }

    public synchronized void checkSetFactory() {
        throw new SecurityException("SetFactory");
    }

    public void checkPrintJobAccess() {
        if (this.inStub()) {
            throw new RMISecurityException("getPrintJob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.inStub()) {
            throw new RMISecurityException("checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.inStub()) {
            throw new RMISecurityException("checkawteventqueueaccess");
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        if (n != 0 && this.inStub()) {
            throw new SecurityException();
        }
    }

    public void checkSecurityAccess(String string) {
        if (this.inStub()) {
            throw new RMISecurityException("checksecurityaccess", string);
        }
    }
}

