/* $Id: xpath.c,v 1.1.1.1 1998/07/29 15:14:30 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"

#include "article.h"
#include "history.h"
#include "group.h"

#include "xpath.h"

EXPORT bool CMDxpath(char *args)
{
	char msgid[MAX_MSGID];
	char xpath[MAX_GROUP*2];
	char buf[MAX_LINE];
	char *p;
	bool ok;
	if (strSnip(args, 0, "<", ">\r\n", msgid, sizeof msgid) < 1)
	{
		emitrn(NNTP_DONTHAVEIT);
		return FALSE;
	}
	rfc822lower (msgid);
	/*
	 * heads are stored as group/artnum_head
	 */
	p = hisGet (msgid);
	if (p)
	{
		p = strchr(p, '/'); /* skip host */
		if (p && *p)
		{
			emitf("%d %s\r\n", NNTP_NOTHING_FOLLOWS_VAL, p+1);
			return TRUE;
		}
	}
	if (!CurrentScfg)
	    CurrentScfg = ServerList->head;
	Cemit (args);
	Cflush ();
	if (!Cget (buf, sizeof buf))
	{
	        CurrentScfg->share->xpath_fail++;
		emitrn (NNTP_SERVERDOWN);
		return FALSE;
	}
	if (strToi(buf) != NNTP_NOTHING_FOLLOWS_VAL)
	{
		struct server_cfg *scfg = ServerList;
		struct server_cfg *cf;

		/*
		 * we are doing a get by <art-id> and current server didn't have it,
		 * so loop through all servers willing to serve this group until
		 * we find one that does have it and make it the current server
		 */

		for (scfg = ServerList; scfg; scfg = scfg->next)
		{
			if (CurrentScfg==scfg)
				continue;
			logd (("trying xpath <%s> on server %s", msgid, scfg->host));
			cf = attachServer (scfg);
			if (!cf)
			    {
				scfg->share->xpath_fail++;
				continue;
			    }
			Cfemitf (cf, "xpath <%s>\r\n", msgid);
			Cfflush (cf);
			if (!Cfget (cf, buf, sizeof (buf)))
			    {
				scfg->share->xpath_fail++;
				continue;
			    }
			if (strToi(buf) == NNTP_NOTHING_FOLLOWS_VAL)
				break;
		}
		if (!scfg)
		{
			emitrn (NNTP_DONTHAVEIT);
			return FALSE;
		}
		emit (buf);
		CurrentScfg = scfg;
	} else
		emit (buf);
	if (sscanf(buf, "%*d %255[^\r\n ]", xpath)!=1 || !safePath(xpath))
	    {
		CurrentScfg->share->xpath_fail++;
		return TRUE; /* bit grey actually */
	    }
	CurrentScfg->share->xpath_good++;
	sprintf(buf, "%.127s/%.512s", CurrentScfg->host, xpath);
	rfc822lower (msgid);
	ok = hisAdd (msgid, buf);
	logd (("adding <%s>:%s to %s (%s)", msgid, buf, con->historyFile, ok ? "suceeded" : "failed"));
	return TRUE;
}
