// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AIS_ExclusionFilter_HeaderFile
#define _AIS_ExclusionFilter_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AIS_ExclusionFilter_HeaderFile
#include <Handle_AIS_ExclusionFilter.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_DataMapOfIntegerListOfInteger_HeaderFile
#include <TColStd_DataMapOfIntegerListOfInteger.hxx>
#endif
#ifndef _SelectMgr_Filter_HeaderFile
#include <SelectMgr_Filter.hxx>
#endif
#ifndef _AIS_KindOfInteractive_HeaderFile
#include <AIS_KindOfInteractive.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_SelectMgr_EntityOwner_HeaderFile
#include <Handle_SelectMgr_EntityOwner.hxx>
#endif
class SelectMgr_EntityOwner;
class TColStd_ListOfInteger;


//!  A framework to reject or to accept only objects of <br>
//! given types and/or signatures. <br>
//! Objects are stored, and the stored objects - along <br>
//! with the flag settings - are used to define the filter. <br>
//! Objects to be filtered are compared with the stored <br>
//! objects added to the filter, and are accepted or <br>
//! rejected according to the exclusion flag setting. <br>
//! -   Exclusion flag on <br>
//!   -   the function IsOk answers true for all objects, <br>
//!    except those of the types and signatures stored <br>
//!    in the filter framework <br>
//! -   Exclusion flag off <br>
//!   -   the funciton IsOk answers true for all objects <br>
//!    which have the same type and signature as the stored ones. <br>
class AIS_ExclusionFilter : public SelectMgr_Filter {

public:
 // Methods PUBLIC
 // 

//! Constructs an empty exclusion filter object defined by <br>
//! the flag setting ExclusionFlagOn. <br>
//! By default, the flag is set to true. <br>
Standard_EXPORT AIS_ExclusionFilter(const Standard_Boolean ExclusionFlagOn = Standard_True);

//! All the AIS objects of <TypeToExclude> <br>
//!          Will be rejected by the IsOk Method. <br>
Standard_EXPORT AIS_ExclusionFilter(const AIS_KindOfInteractive TypeToExclude,const Standard_Boolean ExclusionFlagOn = Standard_True);

//! Constructs an exclusion filter object defined by the <br>
//! enumeration value TypeToExclude, the signature <br>
//! SignatureInType, and the flag setting ExclusionFlagOn. <br>
//! By default, the flag is set to true. <br>
Standard_EXPORT AIS_ExclusionFilter(const AIS_KindOfInteractive TypeToExclude,const Standard_Integer SignatureInType,const Standard_Boolean ExclusionFlagOn = Standard_True);


Standard_EXPORT virtual  Standard_Boolean IsOk(const Handle(SelectMgr_EntityOwner)& anObj) const;

//! Adds the type TypeToExclude to the list of types. <br>
Standard_EXPORT   Standard_Boolean Add(const AIS_KindOfInteractive TypeToExclude) ;


Standard_EXPORT   Standard_Boolean Add(const AIS_KindOfInteractive TypeToExclude,const Standard_Integer SignatureInType) ;


Standard_EXPORT   Standard_Boolean Remove(const AIS_KindOfInteractive TypeToExclude) ;


Standard_EXPORT   Standard_Boolean Remove(const AIS_KindOfInteractive TypeToExclude,const Standard_Integer SignatureInType) ;


Standard_EXPORT   void Clear() ;

  Standard_Boolean IsExclusionFlagOn() const;

  void SetExclusionFlag(const Standard_Boolean Status) ;


Standard_EXPORT   Standard_Boolean IsStored(const AIS_KindOfInteractive aType) const;


Standard_EXPORT   void ListOfStoredTypes(TColStd_ListOfInteger& TheList) const;


Standard_EXPORT   void ListOfSignature(const AIS_KindOfInteractive aType,TColStd_ListOfInteger& TheStoredList) const;
//Standard_EXPORT ~AIS_ExclusionFilter();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean IsSignatureIn(const AIS_KindOfInteractive aType,const Standard_Integer aSignature) const;


 // Fields PRIVATE
 //
Standard_Boolean myIsExclusionFlagOn;
TColStd_DataMapOfIntegerListOfInteger myStoredTypes;


};


#include <AIS_ExclusionFilter.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
