// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_Loop_HeaderFile
#define _BRepAlgo_Loop_HeaderFile

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
class TopoDS_Face;
class TopoDS_Edge;
class TopTools_ListOfShape;
class TopTools_DataMapOfShapeShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Builds the loops from a set of edges on a face. <br>
class BRepAlgo_Loop  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepAlgo_Loop();

//! Init with <F> the set of edges must have <br>
//!          pcurves on <F>. <br>
Standard_EXPORT   void Init(const TopoDS_Face& F) ;

//! Add E with <LV>. <E> will be copied and trim <br>
//!          by vertices in <LV>. <br>
Standard_EXPORT   void AddEdge(TopoDS_Edge& E,const TopTools_ListOfShape& LV) ;

//! Add <E> as const edge, E can be in the result. <br>
Standard_EXPORT   void AddConstEdge(const TopoDS_Edge& E) ;

//! Add <LE> as a set of const edges. <br>
Standard_EXPORT   void AddConstEdges(const TopTools_ListOfShape& LE) ;

//! Make loops. <br>
Standard_EXPORT   void Perform() ;

//!  Cut the  edge <E>  in  several edges  <NE> on the <br>
//!          vertices<VonE>. <br>
Standard_EXPORT   void CutEdge(const TopoDS_Edge& E,const TopTools_ListOfShape& VonE,TopTools_ListOfShape& NE) const;

//! Returns the list of wires performed. <br>
//!          can be an empty list. <br>
Standard_EXPORT  const TopTools_ListOfShape& NewWires() const;

//!  Build faces from the wires result. <br>
Standard_EXPORT   void WiresToFaces() ;

//! Returns the list of faces. <br>
//!  Warning: The method <WiresToFaces> as to be called before. <br>
//!          can be an empty list. <br>
Standard_EXPORT  const TopTools_ListOfShape& NewFaces() const;

//! Returns the list of new edges built from an edge <E> <br>
//!          it can be an empty list. <br>
Standard_EXPORT  const TopTools_ListOfShape& NewEdges(const TopoDS_Edge& E) const;

//! Returns the datamap of vertices with their substitutes. <br>
Standard_EXPORT   void GetVerticesForSubstitute(TopTools_DataMapOfShapeShape& VerVerMap) const;


Standard_EXPORT   void VerticesForSubstitute(TopTools_DataMapOfShapeShape& VerVerMap) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Face myFace;
TopTools_ListOfShape myConstEdges;
TopTools_DataMapOfShapeListOfShape myVerOnEdges;
TopTools_ListOfShape myNewWires;
TopTools_ListOfShape myNewFaces;
TopTools_DataMapOfShapeListOfShape myNewEdges;
TopTools_DataMapOfShapeShape myVerticesForSubstitute;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
