// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_ModifyShape_HeaderFile
#define _BRepBuilderAPI_ModifyShape_HeaderFile

#ifndef _BRepTools_Modifier_HeaderFile
#include <BRepTools_Modifier.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Handle_BRepTools_Modification_HeaderFile
#include <Handle_BRepTools_Modification.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
class BRepTools_Modification;
class Standard_NullObject;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Implements   the  methods   of MakeShape for   the <br>
//!          constant  topology modifications.  The methods are <br>
//!          implemented  when the modification uses a Modifier <br>
//!          from BRepTools. Some of  them have to be redefined <br>
//!          if  the  modification is  implemented with another <br>
//!          tool (see Transform from BRepBuilderAPI for example). <br>
//! The BRepBuilderAPI package provides the following <br>
//! frameworks to perform modifications of this sort: <br>
//! -   BRepBuilderAPI_Copy to produce the copy of a shape, <br>
//! -   BRepBuilderAPI_Transform and <br>
//!   BRepBuilderAPI_GTransform to apply a geometric <br>
//!   transformation to a shape, <br>
//! -   BRepBuilderAPI_NurbsConvert to convert the <br>
//!   whole geometry of a shape into NURBS geometry, <br>
//! -   BRepOffsetAPI_DraftAngle to build a tapered shape. <br>
class BRepBuilderAPI_ModifyShape  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns the list  of shapes modified from the shape <br>
//!          <S>. <br>
Standard_EXPORT virtual const TopTools_ListOfShape& Modified(const TopoDS_Shape& S) ;

//! Returns the modified shape corresponding to <S>. <br>
//! S can correspond to the entire initial shape or to its subshape. <br>
//! Exceptions <br>
//! Standard_NoSuchObject if S is not the initial shape or <br>
//! a subshape of the initial shape to which the <br>
//! transformation has been applied. Raises NoSuchObject from Standard <br>
//! if S is not the initial shape or a sub-shape <br>
//! of the initial shape. <br>
Standard_EXPORT virtual const TopoDS_Shape& ModifiedShape(const TopoDS_Shape& S) const;





protected:

 // Methods PROTECTED
 // 

//! Empty constructor. <br>
Standard_EXPORT BRepBuilderAPI_ModifyShape();

//! Initializes the modifier with  the Shape  <S>, and <br>
//!          set the field <myInitialShape> to <S>. <br>
Standard_EXPORT BRepBuilderAPI_ModifyShape(const TopoDS_Shape& S);

//! Set the field <myModification> with <M>. <br>
Standard_EXPORT BRepBuilderAPI_ModifyShape(const Handle(BRepTools_Modification)& M);

//! Initializes the modifier with  the Shape  <S>, and <br>
//!          set the field <myInitialShape> to <S>, and set the <br>
//!          field <myModification> with  <M>, the performs the <br>
//!          modification. <br>
Standard_EXPORT BRepBuilderAPI_ModifyShape(const TopoDS_Shape& S,const Handle(BRepTools_Modification)& M);

//! Performs the previously  given modification on the <br>
//!          shape <S>. <br>
Standard_EXPORT   void DoModif(const TopoDS_Shape& S) ;

//! Performs the  modification   <M> on a   previously <br>
//!          given shape. <br>
Standard_EXPORT   void DoModif(const Handle(BRepTools_Modification)& M) ;

//! Performs the  modification <M> on the shape <S>. <br>
Standard_EXPORT   void DoModif(const TopoDS_Shape& S,const Handle(BRepTools_Modification)& M) ;


 // Fields PROTECTED
 //
BRepTools_Modifier myModifier;
TopoDS_Shape myInitialShape;
Handle_BRepTools_Modification myModification;


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void DoModif() ;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
