// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _CPnts_AbscissaPoint_HeaderFile
#define _CPnts_AbscissaPoint_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _CPnts_MyRootFunction_HeaderFile
#include <CPnts_MyRootFunction.hxx>
#endif
class StdFail_NotDone;
class Standard_ConstructionError;
class Adaptor3d_Curve;
class Adaptor2d_Curve2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! the algorithm computes a point on a curve at a given <br>
//!          distance from another point on the curve <br>
//! <br>
//!          We can instantiates with <br>
//!            Curve from Adaptor3d, Pnt from gp, Vec from gp <br>
//! <br>
//!          or <br>
//!            Curve2d from Adaptor2d, Pnt2d from gp, Vec2d from gp <br>
class CPnts_AbscissaPoint  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Computes the length of the Curve <C>. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor3d_Curve& C) ;

//! Computes the length of the Curve <C>. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor2d_Curve2d& C) ;

//! Computes the length of the Curve <C> with the given tolerance. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor3d_Curve& C,const Standard_Real Tol) ;

//! Computes the length of the Curve <C> with the given tolerance. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor2d_Curve2d& C,const Standard_Real Tol) ;

//! Computes the length of the Curve <C> between <U1> and <U2>. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor3d_Curve& C,const Standard_Real U1,const Standard_Real U2) ;

//! Computes the length of the Curve <C> between <U1> and <U2>. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor2d_Curve2d& C,const Standard_Real U1,const Standard_Real U2) ;

//! Computes the length of the Curve <C> between <U1> and <U2> with the given tolerance. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor3d_Curve& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol) ;

//! Computes the length of the Curve <C> between <U1> and <U2> with the given tolerance. <br>//! creation of a indefinite AbscissaPoint. <br>
Standard_EXPORT static  Standard_Real Length(const Adaptor2d_Curve2d& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol) ;


Standard_EXPORT CPnts_AbscissaPoint();

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Resolution> is the error allowed in the computation. <br>
//!          The computed point can be outside of the curve 's bounds. <br>
Standard_EXPORT CPnts_AbscissaPoint(const Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Resolution);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Resolution> is the error allowed in the computation. <br>
//!          The computed point can be outside of the curve 's bounds. <br>
Standard_EXPORT CPnts_AbscissaPoint(const Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Resolution);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Ui> is the starting value used in the iterative process <br>
//!          which find the solution, it must be closed to the final <br>
//!          solution <br>
//!          <Resolution> is the error allowed in the computation. <br>
//!          The computed point can be outside of the curve 's bounds. <br>
Standard_EXPORT CPnts_AbscissaPoint(const Adaptor3d_Curve& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui,const Standard_Real Resolution);

//! the algorithm computes a point on a curve <Curve> at the <br>
//!          distance <Abscissa> from the point of parameter <U0>. <br>
//!          <Ui> is the starting value used in the iterative process <br>
//!          which find the solution, it must be closed to the final <br>
//!          solution <br>
//!          <Resolution> is the error allowed in the computation. <br>
//!          The computed point can be outside of the curve 's bounds. <br>
Standard_EXPORT CPnts_AbscissaPoint(const Adaptor2d_Curve2d& C,const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui,const Standard_Real Resolution);

//! Initializes the resolution function with <C>. <br>
Standard_EXPORT   void Init(const Adaptor3d_Curve& C) ;

//! Initializes the resolution function with <C>. <br>
Standard_EXPORT   void Init(const Adaptor2d_Curve2d& C) ;

//! Initializes the resolution function with <C>. <br>
Standard_EXPORT   void Init(const Adaptor3d_Curve& C,const Standard_Real Tol) ;

//! Initializes the resolution function with <C>. <br>
Standard_EXPORT   void Init(const Adaptor2d_Curve2d& C,const Standard_Real Tol) ;

//! Initializes the resolution function with <C> <br>
//!          between U1 and U2. <br>
Standard_EXPORT   void Init(const Adaptor3d_Curve& C,const Standard_Real U1,const Standard_Real U2) ;

//! Initializes the resolution function with <C> <br>
//!          between U1 and U2. <br>
Standard_EXPORT   void Init(const Adaptor2d_Curve2d& C,const Standard_Real U1,const Standard_Real U2) ;

//! Initializes the resolution function with <C> <br>
//!          between U1 and U2. <br>
Standard_EXPORT   void Init(const Adaptor3d_Curve& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol) ;

//! Initializes the resolution function with <C> <br>
//!          between U1 and U2. <br>
Standard_EXPORT   void Init(const Adaptor2d_Curve2d& C,const Standard_Real U1,const Standard_Real U2,const Standard_Real Tol) ;

//! Computes the point at the distance <Abscissa> of <br>
//!          the curve. <br>
Standard_EXPORT   void Perform(const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Resolution) ;

//! Computes the point at the distance <Abscissa> of <br>
//!          the curve. <br>
Standard_EXPORT   void Perform(const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui,const Standard_Real Resolution) ;

//! Computes the point at the distance <Abscissa> of <br>
//!          the curve; performs more appropriate tolerance managment; <br>
//!          to use this method in right way it is necessary to call <br>
//!          empty consructor. then call method Init with <br>
//!	        Tolerance = Resolution, then call AdvPermorm. <br>
Standard_EXPORT   void AdvPerform(const Standard_Real Abscissa,const Standard_Real U0,const Standard_Real Ui,const Standard_Real Resolution) ;
//! True if the computation was successful, False otherwise. <br>
  Standard_Boolean IsDone() const;
//! Returns the parameter of the solution. <br>
//! <br>
  Standard_Real Parameter() const;
//! Enforce the solution, used by GCPnts. <br>
//! <br>
  void SetParameter(const Standard_Real P) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myDone;
Standard_Real myL;
Standard_Real myParam;
Standard_Real myUMin;
Standard_Real myUMax;
CPnts_MyRootFunction myF;


};


#include <CPnts_AbscissaPoint.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
