// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Dynamic_FuzzyDefinitionsDictionary_HeaderFile
#define _Dynamic_FuzzyDefinitionsDictionary_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Dynamic_FuzzyDefinitionsDictionary_HeaderFile
#include <Handle_Dynamic_FuzzyDefinitionsDictionary.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Dynamic_SequenceOfFuzzyDefinitions_HeaderFile
#include <Handle_Dynamic_SequenceOfFuzzyDefinitions.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Dynamic_Parameter_HeaderFile
#include <Handle_Dynamic_Parameter.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Dynamic_FuzzyClass_HeaderFile
#include <Handle_Dynamic_FuzzyClass.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TCollection_HAsciiString;
class Dynamic_SequenceOfFuzzyDefinitions;
class Dynamic_Parameter;
class Dynamic_FuzzyClass;


//! This  class groups   in  a dictionary  all  of the <br>
//!          various definitions of  an object. It  also allows <br>
//!          the  sharing of the   same definition by more than <br>
//!          one  FuzzyInstance to  preserve a global coherence <br>
//!          and also to manage  the memory.  To use this class <br>
//!          an  inheritance  is  necessary with  perhaps   the <br>
//!          overload  of  the  Switch  method if the parameter <br>
//!          types   are   not  of  the  type BooleanParameter, <br>
//!          IntegerParameter,        RealParameter         and <br>
//!          StringParameter. <br>
class Dynamic_FuzzyDefinitionsDictionary : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Starting with   a file named  <afilename>,  fills  the <br>
//!          dictionary with all the wishes definitions. <br>
Standard_EXPORT   void Creates(const Standard_CString afilename) ;

//! This virtual method allows the user to add recognition <br>
//!          of its  own  parameters when reading  the file to fill <br>
//!          the dictionary. <br>
Standard_EXPORT virtual  Handle_Dynamic_Parameter Switch(const Standard_CString aname,const Standard_CString atype,const Standard_CString avalue) const;

//! Returns from     the dictionary in  the   out variable <br>
//!          <adefinition> a reference to the right instance of the <br>
//!          definition identified  by its type <atype>. The method <br>
//!          returns true if the definition exist, false otherwise. <br>
Standard_EXPORT   Standard_Boolean Definition(const Standard_CString atype,Handle(Dynamic_FuzzyClass)& adefinition) const;

//! Returns true if there has been  no modification of the <br>
//!          file  fuzzyclasses.dat  since  the   creation  of  the <br>
//!          dictionary object, false otherwise. <br>
Standard_EXPORT   Standard_Boolean UpToDate() const;

//! Returns    the number  of  definitions  stored  in the <br>
//!          dictionary. <br>
Standard_EXPORT   Standard_Integer NumberOfDefinitions() const;

//! Returns a  reference on the  definition identified  by <br>
//!          the index <anidex>. <br>
Standard_EXPORT   Handle_Dynamic_FuzzyClass Definition(const Standard_Integer anindex) const;

//! Useful for debugging. <br>
Standard_EXPORT   void Dump(Standard_OStream& astream) const;
//Standard_EXPORT ~Dynamic_FuzzyDefinitionsDictionary();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Deferred constructor of the class. <br>
Standard_EXPORT Dynamic_FuzzyDefinitionsDictionary();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString thefilename;
Standard_Integer thetime;
Handle_Dynamic_SequenceOfFuzzyDefinitions thesequenceoffuzzydefinitions;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
