// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomFill_CorrectedFrenet_HeaderFile
#define _GeomFill_CorrectedFrenet_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_GeomFill_CorrectedFrenet_HeaderFile
#include <Handle_GeomFill_CorrectedFrenet.hxx>
#endif

#ifndef _Handle_GeomFill_Frenet_HeaderFile
#include <Handle_GeomFill_Frenet.hxx>
#endif
#ifndef _Handle_Law_Function_HeaderFile
#include <Handle_Law_Function.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfVec_HeaderFile
#include <Handle_TColgp_HArray1OfVec.hxx>
#endif
#ifndef _GeomFill_TrihedronLaw_HeaderFile
#include <GeomFill_TrihedronLaw.hxx>
#endif
#ifndef _Handle_GeomFill_TrihedronLaw_HeaderFile
#include <Handle_GeomFill_TrihedronLaw.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class GeomFill_Frenet;
class Law_Function;
class TColStd_HArray1OfReal;
class TColgp_HArray1OfVec;
class Standard_OutOfRange;
class Standard_ConstructionError;
class GeomFill_TrihedronLaw;
class gp_Vec;
class TColStd_SequenceOfReal;
class TColgp_SequenceOfVec;
class Adaptor3d_HCurve;
class TColStd_Array1OfReal;


//!  Defined an Corrected Frenet  Trihedron  Law It is <br>
//!          like Frenet with an Torsion's minimization <br>
class GeomFill_CorrectedFrenet : public GeomFill_TrihedronLaw {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT GeomFill_CorrectedFrenet();


Standard_EXPORT virtual  Handle_GeomFill_TrihedronLaw Copy() const;


Standard_EXPORT virtual  void SetCurve(const Handle(Adaptor3d_HCurve)& C) ;


Standard_EXPORT virtual  void SetInterval(const Standard_Real First,const Standard_Real Last) ;

//! compute Triedrhon on curve at parameter <Param> <br>
Standard_EXPORT virtual  Standard_Boolean D0(const Standard_Real Param,gp_Vec& Tangent,gp_Vec& Normal,gp_Vec& BiNormal) ;

//! compute Triedrhon and  derivative Trihedron  on curve <br>
//!          at parameter <Param> <br>
//!  Warning : It used only for C1 or C2 aproximation <br>
Standard_EXPORT virtual  Standard_Boolean D1(const Standard_Real Param,gp_Vec& Tangent,gp_Vec& DTangent,gp_Vec& Normal,gp_Vec& DNormal,gp_Vec& BiNormal,gp_Vec& DBiNormal) ;

//! compute  Trihedron on curve <br>
//!          first and seconde  derivatives. <br>
//!  Warning : It used only for C2 aproximation <br>
Standard_EXPORT virtual  Standard_Boolean D2(const Standard_Real Param,gp_Vec& Tangent,gp_Vec& DTangent,gp_Vec& D2Tangent,gp_Vec& Normal,gp_Vec& DNormal,gp_Vec& D2Normal,gp_Vec& BiNormal,gp_Vec& DBiNormal,gp_Vec& D2BiNormal) ;

//! Returns  the number  of  intervals for  continuity <br>
//!          <S>. <br>
//!          May be one if Continuity(me) >= <S> <br>
Standard_EXPORT virtual  Standard_Integer NbIntervals(const GeomAbs_Shape S) const;

//! Stores in <T> the  parameters bounding the intervals <br>
//!          of continuity <S>. <br>
//! <br>
//!          The array must provide  enough room to  accomodate <br>
//!          for the parameters. i.e. T.Length() > NbIntervals() <br>
Standard_EXPORT virtual  void Intervals(TColStd_Array1OfReal& T,const GeomAbs_Shape S) const;

//! Get average value of Tangent(t) and Normal(t) it is usfull to <br>
//!          make fast approximation of rational  surfaces. <br>
Standard_EXPORT virtual  void GetAverageLaw(gp_Vec& ATangent,gp_Vec& ANormal,gp_Vec& ABiNormal) ;

//! Say if the law is Constant. <br>
Standard_EXPORT virtual  Standard_Boolean IsConstant() const;

//! Return True. <br>
Standard_EXPORT virtual  Standard_Boolean IsOnlyBy3dCurve() const;
//Standard_EXPORT ~GeomFill_CorrectedFrenet();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Init() ;

//!  Computes BSpline representation of Normal evolution at one <br>
//! interval of continuity of Frenet. Returns True if FuncInt = 0 <br>
Standard_EXPORT   Standard_Boolean InitInterval(const Standard_Real First,const Standard_Real Last,const Standard_Real Step,Standard_Real& startAng,gp_Vec& prevTangent,gp_Vec& prevNormal,gp_Vec& aT,gp_Vec& aN,Handle(Law_Function)& FuncInt,TColStd_SequenceOfReal& SeqPoles,TColStd_SequenceOfReal& SeqAngle,TColgp_SequenceOfVec& SeqTangent,TColgp_SequenceOfVec& SeqNormal) const;

//!  Computes angle of Normal evolution of Frenet between any two points on the curve. <br>
Standard_EXPORT   Standard_Real CalcAngleAT(const gp_Vec& Tangent,const gp_Vec& Normal,const gp_Vec& prevTangent,const gp_Vec& prevNormal) const;

//!  Get corrected value of angle of Normal evolution of Frenet <br>
Standard_EXPORT   Standard_Real GetAngleAT(const Standard_Real P) const;


 // Fields PRIVATE
 //
Handle_GeomFill_Frenet frenet;
Handle_Law_Function EvolAroundT;
Handle_Law_Function TLaw;
gp_Vec AT;
gp_Vec AN;
Standard_Boolean isFrenet;
Handle_TColStd_HArray1OfReal HArrPoles;
Handle_TColStd_HArray1OfReal HArrAngle;
Handle_TColgp_HArray1OfVec HArrTangent;
Handle_TColgp_HArray1OfVec HArrNormal;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
