// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepBuild_ShellFaceClassifier_HeaderFile
#define _TopOpeBRepBuild_ShellFaceClassifier_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _TopoDS_Shell_HeaderFile
#include <TopoDS_Shell.hxx>
#endif
#ifndef _BRep_Builder_HeaderFile
#include <BRep_Builder.hxx>
#endif
#ifndef _TopOpeBRepTool_SolidClassifier_HeaderFile
#include <TopOpeBRepTool_SolidClassifier.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopOpeBRepBuild_CompositeClassifier_HeaderFile
#include <TopOpeBRepBuild_CompositeClassifier.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
class TopOpeBRepBuild_BlockBuilder;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! Classify faces and shells. <br>
//! shapes are Shells, Elements are Faces. <br>
class TopOpeBRepBuild_ShellFaceClassifier  : public TopOpeBRepBuild_CompositeClassifier {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a classifier in 3D space, to compare : <br>
//! a face with a set of faces <br>
//! a shell with a set of faces <br>
//! a shell with a shell <br>
Standard_EXPORT TopOpeBRepBuild_ShellFaceClassifier(const TopOpeBRepBuild_BlockBuilder& BB);


Standard_EXPORT   void Clear() ;

//! classify shell <B1> with shell <B2> <br>
Standard_EXPORT   TopAbs_State CompareShapes(const TopoDS_Shape& B1,const TopoDS_Shape& B2) ;

//! classify face <F> with shell <S> <br>
Standard_EXPORT   TopAbs_State CompareElementToShape(const TopoDS_Shape& F,const TopoDS_Shape& S) ;

//! prepare classification involving shell <S> <br>
//! calls ResetElement on first face of <S> <br>
Standard_EXPORT   void ResetShape(const TopoDS_Shape& S) ;

//! prepare classification involving face <F> <br>
//! define 3D point (later used in Compare()) on first vertex of face <F>. <br>
Standard_EXPORT   void ResetElement(const TopoDS_Shape& F) ;

//! Add the face <F> in the set of faces used in 3D point <br>
//! classification. <br>
Standard_EXPORT   void CompareElement(const TopoDS_Shape& F) ;

//! Returns state of classification of 3D point, defined by <br>
//! ResetElement, with the current set of faces, defined by Compare. <br>
Standard_EXPORT   TopAbs_State State() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myFirstCompare;
gp_Pnt myPoint3d;
TopoDS_Shell myShell;
BRep_Builder myBuilder;
TopOpeBRepTool_SolidClassifier mySolidClassifier;
TopTools_DataMapOfShapeShape myFaceShellMap;
TopoDS_Shape myShape;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
