// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WNT_FontMapEntry_HeaderFile
#define _WNT_FontMapEntry_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WNT_FontMapEntry_HeaderFile
#include <Handle_WNT_FontMapEntry.hxx>
#endif

#ifndef _WNT_LogFont_HeaderFile
#include <WNT_LogFont.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _WNT_Dword_HeaderFile
#include <WNT_Dword.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class WNT_FontMapEntryDefinitionError;
class WNT_WDriver;
class WNT_DDriver;


//! Defines correspondence between FontMapEntry from <br>
//!          Aspect and Windows NT font handle. Also, provides <br>
//!          some optimizations due to rotation, italics & underlining <br>
//!          of fonts. Each font can be reffered by its name which <br>
//!          is a character string. The format of the string takes <br>
//!          after format of font name of X window system but there <br>
//!          are some differences. The font name string format is: <br>
//!          "h-w-e-o-wgt-i-u-so-cs-op-cp-q-pf-face". <br>
//!           ^ ^ ^ ^  ^  ^ ^ ^  ^  ^  ^  ^ ^   ^ <br>
//!           | | | |  |  | | |  |  |  |  | |   | <br>
//!           | | | |  |  | | |  |  |  |  | |   +- name of the typeface <br>
//!           | | | |  |  | | |  |  |  |  | |      (Courier, Arial ...) <br>
//!           | | | |  |  | | |  |  |  |  | +- pitch and family <br>
//!           | | | |  |  | | |  |  |  |  +- quality <br>
//!           | | | |  |  | | |  |  |  +- clip precision <br>
//!           | | | |  |  | | |  |  +- out precision <br>
//!           | | | |  |  | | |  +- character set <br>
//!           | | | |  |  | | +- strike out <br>
//!           | | | |  |  | +- underline <br>
//!           | | | |  |  +- italic <br>
//!           | | | |  +- weight <br>
//!           | | | +- orientation <br>
//!           | | +- escapement <br>
//!           | +- width <br>
//!           +- height <br>
//!           Wildcarding is allowed by specifying '*' sign. This means <br>
//!           a default value for parameter. <br>
//!  Example: "13-8-*-*-400-*-*-*-255-1-2-*-25-courier". <br>
//!          For more detail information see Microsoft Windows manual. <br>
//!  Warning: Windows can output rotated text only if the selected for <br>
//!          drawing font is True Type. <br>
class WNT_FontMapEntry : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a class and loads font. <br>
//!  Warning: Windows finds the real font that most closely matches <br>
//!          the request. In doing so, it uses a <br>
//!          "font-mapping-algorythm". So it is possible that loaded <br>
//!          font differs from font in the request. <br>
//!  Trigger: Raises if font loading failed. <br>
Standard_EXPORT WNT_FontMapEntry(const Standard_CString aFontName);

//! Destroys all ressources attached to the FontMapEntry <br>
Standard_EXPORT virtual  void Destroy() ;
~WNT_FontMapEntry()
{
  Destroy();
}


//! Returns handle of the font. <br>
Standard_EXPORT   Aspect_Handle HFont() const;

//! Sets certain attributes ( italics etc. ) for font. <br>
//!  Warning: If <aRepl> is True then creates a new handle for font. <br>
//!          In this case calling routine MUST DELETE THE FONT ITSELF <br>
//!          WHEN THE FONT BECOME NO LONGER NEEDED. <br>
Standard_EXPORT   Aspect_Handle SetAttrib(const WNT_Dword& aFlags,const Standard_Address aData,const Standard_Boolean aRepl = Standard_False) ;
//! Sets the font's slant and returns a previous one. <br>
  Quantity_PlaneAngle SetSlant(const Quantity_PlaneAngle aSlant) ;
//! Sets the font's scale and returns a previous one. <br>
  Quantity_Factor SetScale(const Quantity_Factor aScale) ;
//! Returns value of the font's slant. <br>
  Quantity_PlaneAngle Slant() const;
//! Returns value of the font's scale. <br>
  Quantity_Factor Scale() const;
//! Returns pointer to LogFont structure. <br>
  Standard_Address LogFont() const;


friend class WNT_WDriver;
friend class WNT_DDriver;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
WNT_LogFont myLogFont;
Aspect_Handle myHandle;
Quantity_Factor myScale;
Quantity_PlaneAngle mySlant;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <WNT_FontMapEntry.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
