// File:	TopoDSToStep.cxx
// Created:	Tue Dec 13 14:03:54 1994
// Author:	Frederic MAUPAS
//		<fma@stylox>

#include <TopoDSToStep.ixx>
#include <BRepTools_Modifier.hxx>
//#include <TopoDSToStep_DirectModification.hxx>
//#include <TopoDSToStep_ConicalSurfModif.hxx>

#include <TColStd_MapOfTransient.hxx>
#include <TopExp_Explorer.hxx>
#include <TopoDS.hxx>
#include <TopoDS_Face.hxx>
#include <TopLoc_Location.hxx>
#include <Geom_Surface.hxx>
#include <BRep_Tool.hxx>
#include <MDBLIST.hxx>
#include <Transfer_SimpleBinderOfTransient.hxx>
#include <TransferBRep_ShapeMapper.hxx>
#include <TransferBRep.hxx>
#include <Transfer_Binder.hxx>
#include <MoniTool_DataMapOfShapeTransient.hxx>
#include <TopoDSToStep_Tool.hxx>
#include <MoniTool_DataMapIteratorOfDataMapOfShapeTransient.hxx>


Handle(TCollection_HAsciiString) 
TopoDSToStep::DecodeBuilderError(const TopoDSToStep_BuilderError E)
{
  Handle(TCollection_HAsciiString) mess;
  switch(E)
    {
    case TopoDSToStep_BuilderDone:
      {
	mess = new TCollection_HAsciiString("Builder Done");
	break;
      }
    case TopoDSToStep_NoFaceMapped:
      {
	mess = new TCollection_HAsciiString("None of the Shell Faces has been mapped");
	break;
      }
    case TopoDSToStep_BuilderOther:
      {
	mess = new TCollection_HAsciiString("Other Error in Builder");
	break;
      }
    }
  return mess;
}

Handle(TCollection_HAsciiString) 
TopoDSToStep::DecodeFaceError(const TopoDSToStep_MakeFaceError E)
{
  Handle(TCollection_HAsciiString) mess;
  switch(E)
    {
    case TopoDSToStep_FaceDone:
      {
	mess = new TCollection_HAsciiString("Face Done");
	break;
      }
    case TopoDSToStep_FaceOther:
      {
	mess = new TCollection_HAsciiString("Other Error in Make STEP face");
	break;
      }
    case TopoDSToStep_InfiniteFace:
      {
	mess = new TCollection_HAsciiString("The Face has no Outer Wire");
	break;
      }
    case TopoDSToStep_NonManifoldFace:
      {
	mess = new TCollection_HAsciiString("The Face is Internal or External");
	break;
      }
    case TopoDSToStep_NoWireMapped:
      {
	mess = new TCollection_HAsciiString("None of the Face Wires has been mapped");
	break;
      }
    }
  return mess;
}

Handle(TCollection_HAsciiString) 
TopoDSToStep::DecodeWireError(const TopoDSToStep_MakeWireError E)
{
  Handle(TCollection_HAsciiString) mess;
  switch(E)
    {
    case TopoDSToStep_WireDone:
      {
	mess = new TCollection_HAsciiString("Wire Done");
	break;
      }
    case TopoDSToStep_WireOther:
      {
	mess = new TCollection_HAsciiString("Other Error in Make STEP wire");
	break;
      }
    case TopoDSToStep_NonManifoldWire:
      {
	mess = new TCollection_HAsciiString("The Wire is Internal or External");
	break;
	}
    }
  return mess;
}

Handle(TCollection_HAsciiString) 
TopoDSToStep::DecodeEdgeError(const TopoDSToStep_MakeEdgeError E)
{
  Handle(TCollection_HAsciiString) mess;
  switch(E)
    {
    case TopoDSToStep_EdgeDone:
      {
	mess = new TCollection_HAsciiString("Edge Done");
	break;
      }
    case TopoDSToStep_EdgeOther:
      {
	mess = new TCollection_HAsciiString("Other Error in Make STEP Edge");
	break;
      }
    case TopoDSToStep_NonManifoldEdge:
      {
	mess = new TCollection_HAsciiString("The Edge is Internal or External");
	break;
      }
    }
  return mess;
}

Handle(TCollection_HAsciiString) 
TopoDSToStep::DecodeVertexError(const TopoDSToStep_MakeVertexError E)
{
  Handle(TCollection_HAsciiString) mess;
  switch(E)
    {
    case TopoDSToStep_VertexDone:
      {
	mess = new TCollection_HAsciiString("Vertex Done");
	break;
      }
    case TopoDSToStep_VertexOther:
      {
	mess = new TCollection_HAsciiString("Other Error in Make STEP Vertex");
	break;
      }
    }
  return mess;
}

/*
TopoDS_Shape TopoDSToStep::DirectFaces(const TopoDS_Shape& S)
{
//  On s assure que les faces ont toutes des surfaces support directes
//  Sinon on les change. Mais alors, il faut reprendre les pcurves ...
//  Genant surtout si couture : les outils internes se basent sur les pcurves
//  Noter les surfaces qui ont bouge ? inutile, elles bougent sur place ...

//  TColStd_MapOfTransient surfs;
//  surfs.ReSize(4000);
//  for (TopExp_Explorer faces (S,TopAbs_FACE); faces.More(); faces.Next()) {
//    TopoDS_Face F = TopoDS::Face (faces.Current());
//    TopLoc_Location loc;
//    Handle(Geom_Surface) surf = BRep_Tool::Surface (F,loc);
//    if (!surf.IsNull()) surfs.Add (surf);
//  }

  TopoDS_Shape NS;    // new shape ?

  // Create a modification description for Conical Surfaces
  Handle(TopoDSToStep_ConicalSurfModif) CSM = 
    new TopoDSToStep_ConicalSurfModif();
  
  BRepTools_Modifier ConicalModifier(S,CSM);

  if (ConicalModifier.IsDone()) {

    TopoDS_Shape newShape = ConicalModifier.ModifiedShape(S);

    // Create a modification description
    Handle(TopoDSToStep_DirectModification) DM = 
      new TopoDSToStep_DirectModification();
    
    // Modify the shape
    BRepTools_Modifier M(newShape,DM);
    if(M.IsDone()) {
      NS = M.ModifiedShape(newShape);
    }
    else
      return S;
  }
  else
    return S;

  SDBCUR.Add("DirectFaces");
  SDBCUR.AddShape(NS);
  return NS;
}
*/

//=======================================================================
//function : AddResult
//purpose  : 
//=======================================================================

void TopoDSToStep::AddResult (const Handle(Transfer_FinderProcess)& FP,
			      const TopoDS_Shape &Shape,
			      const Handle(Standard_Transient) &ent)
{
  Handle(Transfer_SimpleBinderOfTransient) result = new Transfer_SimpleBinderOfTransient;
  result->SetResult (ent);

  Handle(TransferBRep_ShapeMapper) mapper = TransferBRep::ShapeMapper (FP,Shape);
  Handle(Transfer_Binder) binder = FP->Find ( mapper );

  if ( binder.IsNull() ) FP->Bind ( mapper, result );
  else binder->AddResult ( result );
}

//=======================================================================
//function : AddResult
//purpose  : 
//=======================================================================

void TopoDSToStep::AddResult (const Handle(Transfer_FinderProcess)& FP,
			      const TopoDSToStep_Tool &Tool)
{
  const MoniTool_DataMapOfShapeTransient &Map = Tool.Map();
  MoniTool_DataMapIteratorOfDataMapOfShapeTransient it ( Map );
  for ( ; it.More(); it.Next() ) 
    TopoDSToStep::AddResult ( FP, it.Key(), it.Value() );
}
