function Makename=ilib_gen_Make(name,files,libs,makename,with_gateway)
//------------------------------------
// generate a Makefile for gateway
if argn(2)<5 then with_gateway=%t,end
files=strsubst(strsubst(files,'.obj','') ,'.o',''); //compat
comp_target = getenv('COMPILER','NO');
if getenv('WIN32','NO')=='OK' then
  select comp_target
	case 'VC++'   then Makename = makename+'.mak'
	case 'ABSOFT' then Makename = makename+'.amk'
	else Makename = makename;
  end
  ilib_gen_Make_win32(name,files,libs,Makename,with_gateway)
else
  Makename = makename;
  ilib_gen_Make_unix(name,files,libs,Makename,with_gateway)
end

function ilib_gen_Make_unix(name,files,libs,Makename,with_gateway)
fd=mopen(Makename,"w");
mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
mfprintf(fd,"# ------------------------------------------------------\n");
mfprintf(fd,"SCIDIR = %s\n",SCI);
mfprintf(fd,"OBJS = ")
for x=files(:)' ; mfprintf(fd," %s.o",x);end
if with_gateway then mfprintf(fd," %s.o",name);end
mfprintf(fd,"\n") ;
mfprintf(fd,"OTHERLIBS = ")
for x=libs(:)' ; mfprintf(fd," %s",x);end
mfprintf(fd,"\n") ;
mfprintf(fd,"LIBRARY = %s\n",name);
mfprintf(fd,"include $(SCIDIR)/Makefile.incl\n");
mfprintf(fd,"CFLAGS = $(CC_OPTIONS) -I"+SCI+"/routines\n");
mfprintf(fd,"FFLAGS = $(FC_OPTIONS) -I"+SCI+"/routines\n");
mfprintf(fd,"include $(SCIDIR)/config/Makeso.incl\n");
mclose(fd);

function ilib_gen_Make_win32(name,files,libs,Makename,with_gateway)
fd=mopen(Makename,"w");
mfprintf(fd,"# generated by builder.sce: Please do not edit this file\n");
mfprintf(fd,"# ------------------------------------------------------\n");
mfprintf(fd,"SHELL = /bin/sh\n");
mfprintf(fd,"SCIDIR =%s\n",SCI);
mfprintf(fd,"SCIDIR1 =%s\n",WSCI);
mfprintf(fd,"# name of the dll to be built\n"); 
mfprintf(fd,"LIBRARY = %s\n",name);
mfprintf(fd,"# list of objects file\n");
mfprintf(fd,"OBJS =");
for x=files(:)' ; mfprintf(fd," %s.obj",x);end
if with_gateway then mfprintf(fd," %s.obj",name);end
mfprintf(fd,"# added libraries \n");
mfprintf(fd,"OTHERLIBS = ");
for x=libs(:)' ; mfprintf(fd," %s",x);end
mfprintf(fd,"\n################ do not edit below this line ############################\n");
mfprintf(fd,"!include $(SCIDIR1)\\config\\Makedll.incl \n");
mclose(fd);


