.TH bilin 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
bilin - general bilinear transform
.SH CALLING SEQUENCE
.nf
[sl1]=bilin(sl,v)
.fi
.SH PARAMETERS
.TP
sl,sl1
: linear systems (\fVsyslin\fR lists)
.TP
v
: real vector with 4 entries (\fVv=[a,b,c,d]\fR)
.SH DESCRIPTION
Given a linear system in state space form, \fVsl=syslin(dom,A,B,C,D)\fR 
(\fVsyslin\fR list), \fVsl1=bilin(sl,v)\fR  returns in \fVsl1\fR a 
linear system with matrices \fV[A1,B1,C1,D1]\fR such that
the transfer function \fVH1(s)=C1*inv(s*eye()-A1)*B1+D1\fR is
obtained from \fVH(z)=C*inv(z*eye()-A)*B+D\fR by replacing \fVz\fR
by \fVz=(a*s+b)/(c*s+d)\fR.
One has \fVw=bilin(bilin(w,[a,b,c,d]),[d,-b,-c,a])\fR
.SH EXAMPLE
.nf
s=poly(0,'s');z=poly(0,'z');
w=ssrand(1,1,3);
wtf=ss2tf(w);v=[2,3,-1,4];a=v(1);b=v(2);c=v(3);d=v(4);
[horner(wtf,(a*z+b)/(c*z+d)),ss2tf(bilin(w,[a,b,c,d]))]
clean(ss2tf(bilin(bilin(w,[a,b,c,d]),[d,-b,-c,a]))-wtf)
.fi
.SH SEE ALSO
horner, cls2dls


