.TH mput 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
mput - writes  byte or word in a given binary format
.SH CALLING SEQUENCE
.nf
mput(x [,type,fd]) 
.fi
.SH PARAMETERS
.TP 10
x
: a vector of floating point or integer type numbers 
.TP
fd
: scalar. The \fVfd\fR parameter returned by the function. 
Default value is -1 which stands for the last (\fVmopen\fR) opened file.
.TP 
type
: a string. Give the binary format used to write all the entries of x.
.SH DESCRIPTION
The \fVmput\fR function writes data to the output specified by the
stream parameter \fVfd\fR. Data is written at the
position at which the file pointer is currently pointing and 
advances the indicator appropriately. 
.LP
The \fVtye\fR parameter is a conversion specifier which may be set to any of the
following flag characters (with default value "l"):
.TP 13
"l","i","s","ul","ui","us","d","f","c","uc"
: for  writing respectively a long, an int, a short, an unsigned
long, an unsigned int, an unsigned short, a double, a float, a char and an unsigned
char. The bytes which are wrote are automatically swapped if necessary (by checking
little-endian status) in order to produce machine independent binary
files ( in little-endian mode). This default swapping mode can be
suppressed by adding a flag in the \fVmopen\fR function. 
.TP
"..l" or "..b" 
: It is also possible to write in little-endian or big-endian mode 
by adding a 'l' or 'b' character at the end of a type specification.
For example "db" will write a double in big-endian mode.
.SH EXAMPLE 
.nf 
  filen = 'test.bin';
  mopen(filen,'wb');
  mput(1996,'l');mput(1996,'i');mput(1996,'s');mput(98,'c');
// force little-endian 
  mput(1996,'ll');mput(1996,'il');mput(1996,'sl');mput(98,'cl');
// force big-endian 
  mput(1996,'lb');mput(1996,'ib');mput(1996,'sb');mput(98,'cb');
//
  mclose();
  mopen(filen,'rb');
  if 1996<>mget(1,'l') then pause,end
  if 1996<>mget(1,'i') then pause,end
  if 1996<>mget(1,'s') then pause,end
  if   98<>mget(1,'c') then pause,end
  // force little-endian
  if 1996<>mget(1,'ll') then pause,end
  if 1996<>mget(1,'il') then pause,end
  if 1996<>mget(1,'sl') then pause,end
  if   98<>mget(1,'cl') then pause,end
  // force big-endian 
  if 1996<>mget(1,'lb') then pause,end
  if 1996<>mget(1,'ib') then pause,end
  if 1996<>mget(1,'sb') then pause,end
  if   98<>mget(1,'cb') then pause,end
  //
  mclose();
.fi 
.SH SEE ALSO
mclose, meof, mfprintf, fprintfMat, mfscanf, fscanfMat, mget, mgetstr, mopen, mprintf, mput, mputstr, mscanf, mseek, mtell



