.TH fcontour2d 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
fcontour2d - level curves of a surface defined by a function on a 2D plot
.SH CALLING SEQUENCE
.nf
fcontour2d(xr,yr,f,nz,[style,strf,leg,rect,nax])
fcontour2d(xr,yr,f,nz,<opt_args>)
.fi
.SH PARAMETERS
.TP 7
xr,yr 
: two real row vectors of size n1 and n2.
.TP
f
: is an external which defines the surface
\fVz=f(x,y)\fR. It is first computed on the grid specified by
\fVxr,yr\fR. Then, control is passed to the routine \fVcontour2d\fR.
.TP
nz 
: the level values or the number of levels.
.RS
.TP 3
-
If \fVnz\fR is an integer, its value gives the number of level curves 
equally spaced from zmin to zmax.
.TP
-
If \fVnz\fR is a vector, \fVnz(i)\fR gives the value of the ith level curve.
.RE
<opt_args>
: This represents a sequence of statements \fVkey1=value1,
key2=value2\fR,... where \fVkey1\fR, \fVkey2,...\fR can be one of the
following: style, leg, rect, nax, strf or axesflag and frameflag (see plot2d)
.TP
[style,strf,leg,rect,nax]
: see \fVcontour2d\fR.
.SH DESCRIPTION
Draws level curves of a surface \fVz=f(x,y)\fR. The level curves are
drawn on a 2D plot. The surface is given by the external function
\fVf\fR. See \fVcontour2d\fR.

Enter the command \fVfcontour2d()\fR to see a demo.
.SH EXAMPLE
.nf
deff('z=surf(x,y)','z=x^4-y^4')
x=-3:0.1:3;
y=x;
fcontour2d(x,y,surf,10);
.fi
.SH SEE ALSO
contour, contour2d, fcontour
.SH AUTHOR
J.Ph.C.
