.TH pvm_probe 1 "May 1998" "Scilab // Group" "Scilab function"
.so ../sci.an
.SH NAME
pvm_probe - Check if message has arrived.
.SH CALLING SEQUENCE
.nf
[buffid] = pvm_probe(tid, msgtag)
.fi
.SH PARAMETERS
.TP 5
tid
: integer, task identifier of sending process supplied by the user.
.TP 5
msgtag : integer, message tag supplied by the user.  msgtag should be
>= 0.
.TP 6
buffid
: integer, returning  the  value  of  the  new  active
             receive  buffer  identifier.   Values less than zero
             indicate an error.

.SH DESCRIPTION
\fVpvm_probe\fR 
checks to see if a message with  label
     msgtag  has  arrived  from  tid.  If  a matching message has
     arrived pvm_probe returns a buffer identifier in bufid. This
     bufid  can be used in a pvm_bufinfo call to determine infor-
     mation about the message such as its source and length.

     If the requested message has  not  arrived,  then  pvm_probe
     returns  with  a 0 in bufid. If some error occurs bufid will
     be < 0.

     A -1 in msgtag or tid matches  anything.   This  allows  the
     user  the  following  options.   If  tid  = -1 and msgtag is
     defined by the user, then pvm_probe will  accept  a  message
     from  any  process which has a matching msgtag.  If msgtag =
     -1 and tid is defined  by  the  user,  then  pvm_probe  will
     accept  any message that is sent from process tid.  If tid =
     -1 and msgtag = -1, then pvm_probe will accept  any  message
     from any process.

     pvm_probe can be called multiple times to check if  a  given
     message  has  arrived  yet.  After  the message has arrived,
     pvm_recv must be called before the message can  be  unpacked
     into the user's memory using the unpack routines.

.SH EXAMPLE
.nf
arrived = pvm_probe( tid, msgtag );
if (arrived >= 0) then [bytes, msgtag, tid, info] = pvm_info(arrived); end
.fi
.SH SEE ALSO
pvm_recv,  pvm_info

