.TH auwrite 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
auwrite - writes .au sound file
.SH CALLING SEQUENCE
.nf
auwrite(y,aufile)
auwrite(y,Fs,aufile)
auwrite(y,Fs,bits,aufile)
auwrite(y,Fs,bits,method,aufile)
.fi
.SH PARAMETERS
.TP
y
: real vector or matrix with entries in [-1,1].
.TP
aufile
: string (The .au extension is appended if no extension is given)
.TP
Fs
: integer, frequency sampling in Hz.
.TP
bits
: integer, number of bits in the encoding.
.TP
method
: string , \fV'mu'\fR (default) or \fV'linear'\fR, encoding method.
.SH DESCRIPTION
Utility function to save \fV.au\fR sound file.
\fVauwrite(y,aufile)\fR writes a sound file specified by the
string aufile.  The data should be arranged with one channel
per column.  Amplitude values outside the range [-1,+1] are
ignored.
Supports multi-channel data for 8-bit mu-law, and 8- and 16-bit linear formats.

\fVauwrite(y,Fs,aufile)\fR specifies in \fVFs\fR the sample rate of the data
in Hertz.

\fVauwrite(y,Fs,bits,aufile)\fR selects the number of bits in
the encoder.  Allowable settings are bits=8 and bits=16.
 
\fVauwrite(y,Fs,bits,method,aufile)\fR allows selection of the
encoding method, which can be either 'mu' or 'linear'.
Note that mu-law files must be 8-bit. By default, method='mu'.

.SH SEE ALSO
auread, wavread, savewave,  analyze, mapsound
