.TH "findobj" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
findobj - find an object with specified property

.SH CALLING SEQUENCE
h=findobj(prop,value)
.SH PARAMETERS
.TP
o 
prop : string character
Name of the property to test.
.TP
o 
value : string character
specify the value the tested propoerty should be equal to.
o 
h : handle of the found object.
.SH DESCRIPTION
This routine is currentlyt used to find objects knowing their 'tag'
property.  It returns handle of the first found object which property
'prop' is equal to 'value'. If such an object does not exist, the
function returns a void matrix.
.SH EXAMPLE
.nf
h=figure();
// creates  figure number 1.
uicontrol( h, 'style','text', ...
 'string','This is a figure', ...
 'position',[50 70 100 100], ...
 'fontsize',15, ...
 'tag','Alabel');
// put a  text in figure 1
lab=findobj('tag','Alabel');
// find the object which 'tag' value is 'Alabel'
disp('the handle of the label is '+string(lab));
close();
.fi
.SH SEE ALSO
uicontrol, uimenu, set, get 
.SH AUTHOR
Bertrand Guiheneuf
