.TH ilib_gen_Make 1 "May 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
ilib_gen_Make - utility for ilib_build: produces a makefile for building shared libraries
.SH CALLING SEQUENCE
.nf
Makename=ilib_gen_Make(name,files,libs,makename [,with_gateway])
.fi
.SH PARAMETERS
.TP 10
lib_name
: a character string, the generic name of the library without path and
extension.
.TP 10
files
: a vector of character string. The names of the C or Fortran files without
the extension and the path part.
.TP 10
libs
: a vector of character string. additionnal libraries paths or [].
.TP 10
makename
: character string. The path of the Makefile file.
.TP 10
with_gateway
: a boolean. If true a file with name <lib_name>_gateway is added.
.TP 10
Makename
: character string. The path of the really generated Makefile file.
.SH DESCRIPTION
Utility function used by \fVilib_build\fR

This function generates a makefile adapted to the Operating System for
building shared libraries to be loaded in Scilab. Proper options and
paths are set.
.LP
Shared libraries can then be used with the \fVlink\fR and
\fVaddinter\fR scilab function for incremental linking.
.LP
The shared library is build from a set of C or Fortran routines
stored in a directory and if required from a set of external
libraries.
.LP
Files are not required to exist, when makefile is generated, but of
course are required for executing the makefile.
.SH SEE ALSO
addinter, link, ilib_build, ilib_compile, ilib_gen_gateway,
ilib_gen_loader, ilib_for_link
