/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;

import javax.swing.*;

import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.theme.ThemeChangeListener;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceConstants.Side;

/**
 * Test application that shows the use of the
 * {@link SubstanceLookAndFeel#hideMenuSearchPanels()} and
 * {@link SubstanceLookAndFeel#showMenuSearchPanels()} APIs.
 * 
 * @author Kirill Grouchnikov
 * @see SubstanceLookAndFeel#hideMenuSearchPanels()
 * @see SubstanceLookAndFeel#showMenuSearchPanels()
 */
public class HideShowMenuSearchPanels extends JFrame {
	/**
	 * Creates the main frame for <code>this</code> sample.
	 */
	public HideShowMenuSearchPanels() {
		super("Hide / show menu search panels");

		this.setLayout(new BorderLayout());

		// create sample menu bar with two menus
		JMenuBar jmb = new JMenuBar();
		JMenu menu = new JMenu("menu");
		menu.add(new JMenuItem("test item 1", Check.getIcon("flag_mexico")));
		menu.add(new JMenuItem("test item 2"));
		menu.add(new JMenuItem("test item 3"));
		menu.addSeparator();
		menu.add(new JMenuItem("test menu item 4"));
		menu
				.add(new JMenuItem("test menu item 5", Check
						.getIcon("flag_sweden")));
		menu.add(new JMenuItem("test menu item 6"));
		jmb.add(menu);

		JMenu menu2 = new JMenu("big");
		for (int i = 0; i < 35; i++)
			menu2.add(new JMenuItem("menu item " + i));
		jmb.add(menu2);

		this.setJMenuBar(jmb);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		final JCheckBox showMenuSearchPanels = new JCheckBox(
				"Show menu search panels");
		showMenuSearchPanels.setSelected(true);
		showMenuSearchPanels.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						if (showMenuSearchPanels.isSelected()) {
							SubstanceLookAndFeel.showMenuSearchPanels();
						} else {
							SubstanceLookAndFeel.hideMenuSearchPanels();
						}
					}
				});
			}
		});
		controls.add(showMenuSearchPanels);
		this.add(controls, BorderLayout.SOUTH);
		
		this.add(getToolbar("Sample"), BorderLayout.NORTH);

		this.setSize(400, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	/**
	 * The main method for <code>this</code> sample. The arguments are
	 * ignored.
	 * 
	 * @param args
	 *            Ignored.
	 * @throws Exception
	 *             If some exception occured. Note that there is no special
	 *             treatment of exception conditions in <code>this</code>
	 *             sample code.
	 */
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SubstanceLookAndFeel.setCurrentDecorationPainter(new ArcDecorationPainter());
		JFrame.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new HideShowMenuSearchPanels().setVisible(true);
			}
		});
	}
	
	private static JToolBar getToolbar(String label) {
		JToolBar toolBar = new JToolBar("Formatting");
		toolBar.add(new JLabel(label));

		toolBar.add(new JSeparator(SwingConstants.VERTICAL));
		toolBar.add(new JComboBox(new String[] { "aa", "bb", "cc" }));

		final JToggleButton toggleButton1 = new JToggleButton("toggle",
				new ImageIcon(SubstanceImageCreator.getBigHexaMarker(5,
						SubstanceLookAndFeel.getTheme())));
		toolBar.add(toggleButton1);
		final JToggleButton toggleButton2 = new JToggleButton(new ImageIcon(
				SubstanceImageCreator.getBigHexaMarker(8, SubstanceLookAndFeel
						.getTheme())));
		toolBar.add(toggleButton2);
		// final JToggleButton toggleButton3 = new JToggleButton(new ImageIcon(
		// SubstanceImageCreator.getBigHexaMarker(12, SubstanceLookAndFeel
		// .getTheme())));
		// toolBar.add(toggleButton3);
		final JButton button1 = new JButton("regular", new ImageIcon(
				SubstanceImageCreator.getBigHexaMarker(7, SubstanceLookAndFeel
						.getTheme())));
		button1.putClientProperty(SubstanceLookAndFeel.CORNER_RADIUS, Float
				.valueOf(5.0f));
		toolBar.add(button1);
		final JButton button2 = new JButton(new ImageIcon(SubstanceImageCreator
				.getBigHexaMarker(15, SubstanceLookAndFeel.getTheme())));
		button2.putClientProperty(SubstanceLookAndFeel.CORNER_RADIUS, Float
				.valueOf(0.0f));
		toolBar.add(button2);

		final JButton button3 = new JButton(new ImageIcon(SubstanceImageCreator
				.getBigHexaMarker(15, SubstanceLookAndFeel.getTheme())));
		button3.setEnabled(false);
		toolBar.add(button3);
		final JToggleButton toggleButton4 = new JToggleButton(new ImageIcon(
				SubstanceImageCreator.getBigHexaMarker(15, SubstanceLookAndFeel
						.getTheme())));
		toggleButton4.setEnabled(false);
		toggleButton4.setSelected(true);
		toolBar.add(toggleButton4);
		toolBar.addSeparator();

		JPanel groupPanel = new JPanel();
		BoxLayout groupLayout = new BoxLayout(groupPanel, BoxLayout.LINE_AXIS);
		groupPanel.setLayout(groupLayout);
		final JToggleButton togEast = new JToggleButton(new ImageIcon(
				SubstanceImageCreator.getBigHexaMarker(10, SubstanceLookAndFeel
						.getTheme())));
		Set<Side> rightSide = new HashSet<Side>();
		rightSide.add(Side.RIGHT);
		togEast.putClientProperty(
				SubstanceLookAndFeel.BUTTON_OPEN_SIDE_PROPERTY, rightSide);
		togEast.putClientProperty(SubstanceLookAndFeel.CORNER_RADIUS, Float
				.valueOf(3.0f));
		final JToggleButton togCenter = new JToggleButton(new ImageIcon(
				SubstanceImageCreator.getBigHexaMarker(11, SubstanceLookAndFeel
						.getTheme())));
		togCenter.putClientProperty(SubstanceLookAndFeel.CORNER_RADIUS, Float
				.valueOf(0.0f));
		togCenter.putClientProperty(
				SubstanceLookAndFeel.BUTTON_OPEN_SIDE_PROPERTY, rightSide);
		final JToggleButton togWest = new JToggleButton(new ImageIcon(
				SubstanceImageCreator.getBigHexaMarker(12, SubstanceLookAndFeel
						.getTheme())));
		togWest.putClientProperty(SubstanceLookAndFeel.BUTTON_SIDE_PROPERTY,
				SubstanceConstants.Side.LEFT.name());
		togWest.putClientProperty(SubstanceLookAndFeel.CORNER_RADIUS, Float
				.valueOf(3.0f));
		togEast.setSelected(true);
		groupPanel.add(togEast);
		groupPanel.add(togCenter);
		groupPanel.add(togWest);

		toolBar.add(groupPanel);

		SubstanceLookAndFeel
				.registerThemeChangeListener(new ThemeChangeListener() {
					public void themeChanged() {
						toggleButton1.setIcon(new ImageIcon(
								SubstanceImageCreator.getBigHexaMarker(5,
										SubstanceLookAndFeel.getTheme())));
						toggleButton2.setIcon(new ImageIcon(
								SubstanceImageCreator.getBigHexaMarker(8,
										SubstanceLookAndFeel.getTheme())));
						button1.setIcon(new ImageIcon(SubstanceImageCreator
								.getBigHexaMarker(7, SubstanceLookAndFeel
										.getTheme())));
						button2.setIcon(new ImageIcon(SubstanceImageCreator
								.getBigHexaMarker(15, SubstanceLookAndFeel
										.getTheme())));
						button3.setIcon(new ImageIcon(SubstanceImageCreator
								.getBigHexaMarker(15, SubstanceLookAndFeel
										.getTheme())));
						toggleButton4.setIcon(new ImageIcon(
								SubstanceImageCreator.getBigHexaMarker(15,
										SubstanceLookAndFeel.getTheme())));
						togEast.setIcon(new ImageIcon(SubstanceImageCreator
								.getBigHexaMarker(10, SubstanceLookAndFeel
										.getTheme())));
						togCenter.setIcon(new ImageIcon(SubstanceImageCreator
								.getBigHexaMarker(11, SubstanceLookAndFeel
										.getTheme())));
						togWest.setIcon(new ImageIcon(SubstanceImageCreator
								.getBigHexaMarker(12, SubstanceLookAndFeel
										.getTheme())));
					}
				});

		return toolBar;
	}
}
