package test;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class Table extends JFrame {
	public Table() {
		super("Some simple text");
		this.setLayout(new BorderLayout());
		final JTable table = new JTable(2, 2) {
			@Override
			public Object getValueAt(int row, int column) {
				return row + ":" + column;
			}
		};
		table.setColumnSelectionAllowed(true);
		table.setRowSelectionAllowed(true);
		table.setTableHeader(new JTableHeader(table.getColumnModel()));
		table.setIntercellSpacing(new Dimension(12, 10));
		table.setRowHeight(30);
		table.setShowGrid(false);
		table.setDefaultRenderer(Object.class, new TableCellRenderer() {
			public Component getTableCellRendererComponent(JTable table,
					Object value, boolean isSelected, boolean hasFocus,
					int row, int column) {
				JTextField field = new JTextField(value.toString());
				return field;
			}
		});

		this.add(new JScrollPane(table), BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		final JCheckBox hasVertical = new JCheckBox("vertical");
		hasVertical.setSelected(table.getShowVerticalLines());
		hasVertical.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				table.setShowVerticalLines(hasVertical.isSelected());
			}
		});
		controls.add(hasVertical);
		final JCheckBox hasHorizontal = new JCheckBox("horizontal");
		hasHorizontal.setSelected(table.getShowHorizontalLines());
		hasHorizontal.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				table.setShowHorizontalLines(hasHorizontal.isSelected());
			}
		});
		controls.add(hasHorizontal);
		this.add(controls, BorderLayout.SOUTH);

		this.setSize(600, 400);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new Table().setVisible(true);
			}
		});
	}
}
