package test.contrib;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceRavenLookAndFeel;

public class ComboBoxTest extends JFrame {

	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(new SubstanceRavenLookAndFeel());
		} catch (UnsupportedLookAndFeelException e) {
			System.out.println(e);
		}
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ComboBoxTest("Test");
			}
		});
	}

	public ComboBoxTest(String title) {
		super(title);
		initGUI();
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		setLocationRelativeTo(null);
		addWindowListener(new WindowAdapter() {

			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		pack();
		setVisible(true);
	}

	private void initGUI() {
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		Vector<String> boxVector = new Vector<String>();
		boxVector.add("Test 1");
		boxVector.add("Test 2");
		JComboBox comboBox = new JComboBox(boxVector);

		// I get NPE in SubstanceComboBoxUI when I set a font while creating the
		// combobox.
		// everything works fine when I don't set any font, here
		comboBox.setFont(new Font("Verdana", Font.PLAIN, 12));

		comboBox.setEditable(true);

		panel.add(comboBox, BorderLayout.CENTER);
		getContentPane().add(panel);
	}
}
