package test.contrib;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.SpecularGradientPainter;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.SubstanceConstants;

public class ScrollBarEars extends JFrame implements ActionListener {
	Container c;

	JList list;

	JButton button;

	boolean clicked = false;

	int guiWidth = 500;

	int guiHeight = 0;

	public ScrollBarEars() {
		super("JScrollPane Bug Demo");

		c = getContentPane();

		c.setLayout(new FlowLayout());
		setResizable(false);
		setDefaultCloseOperation(EXIT_ON_CLOSE);

		showList();
	}

	public static void main(String[] args) {
		initSubstance();
		new ScrollBarEars();
	}

	void cout(String out) {
		System.out.println(out);
	}

	JScrollPane setList() {
		JScrollPane thePane;
		DefaultListModel theModel = new DefaultListModel();
		// movie temp;

		for (int i = 0; i < 25; i++) {
			theModel.addElement("item " + (i + 1));
		}

		list = new JList(theModel);

		list
				.setToolTipText("When you click on this movie, you will set the movie poster on the right to be associated with this movie.");

		thePane = new JScrollPane(list);
		thePane.setPreferredSize(new Dimension(150, 300));

		return thePane;
	}

	void showList() {
		button = new JButton("Change Complex Theme");
		button.addActionListener(this);

		JPanel panel = new JPanel(new FlowLayout());
		panel.setPreferredSize(new Dimension(250, 350));

		panel.add(button);
		panel.add(setList());

		c.add(panel);

		setLocation(500, 300);
		pack();
		setVisible(true);

		list.ensureIndexIsVisible(20);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == button) {
			changeThemes();
		}
	}

	void changeThemes() {
		// new SubstanceComplexTheme("CurrentTheme", themeKind,
		// activeTheme, defaultTheme, disabledTheme, activePaneTheme,
		// watermarkTheme);
		final SubstanceTheme currentTheme = new SubstanceComplexTheme("CurrentTheme",
				ThemeKind.BRIGHT, new SubstanceLimeGreenTheme(),
				new SubstanceOrangeTheme(), new SubstanceRaspberryTheme(),
				new SubstanceSunsetTheme(), new SubstanceLimeGreenTheme());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				SubstanceLookAndFeel.setCurrentTheme(currentTheme);
				SwingUtilities.updateComponentTreeUI(ScrollBarEars.this);
			}
		});
	}

	static void initSubstance() {
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
			SubstanceLookAndFeel
					.setCurrentGradientPainter(new SpecularGradientPainter());
			UIManager.put(SubstanceLookAndFeel.FOCUS_KIND,
					SubstanceConstants.FocusKind.NONE);
			UIManager
					.put(SubstanceLookAndFeel.WATERMARK_TO_BLEED, Boolean.TRUE);
			UIManager.put(SubstanceLookAndFeel.NO_EXTRA_ELEMENTS, Boolean.TRUE);
			JFrame.setDefaultLookAndFeelDecorated(true);
			JDialog.setDefaultLookAndFeelDecorated(true);
			SubstanceTheme currentTheme = new SubstanceComplexTheme(
					"CurrentTheme", ThemeKind.BRIGHT,
					new SubstanceLimeGreenTheme().invert(),
					new SubstanceOrangeTheme().invert(),
					new SubstanceRaspberryTheme().invert(),
					new SubstanceSunsetTheme().invert(),
					new SubstanceLimeGreenTheme().invert());
			SubstanceLookAndFeel.setCurrentTheme(currentTheme);
		} catch (Exception e) {
			System.err.println("Failed to initialize substance.");
		}
	}
}