/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Scale
extends Control {
    static final int TrackBarProc;
    static final TCHAR TrackBarClass;

    static {
        TrackBarClass = new TCHAR(0, "msctls_trackbar32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TrackBarClass, wNDCLASS);
        TrackBarProc = wNDCLASS.lpfnWndProc;
        int n = OS.GetModuleHandle(null);
        int n2 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n;
        wNDCLASS.style &= 0xFFFFBFFF;
        wNDCLASS.style |= 8;
        int n3 = TrackBarClass.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, TrackBarClass, n3);
        wNDCLASS.lpszClassName = n4;
        OS.RegisterClass(wNDCLASS);
    }

    public Scale(Composite composite, int n) {
        super(composite, Scale.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TrackBarProc, this.handle, n, n2, n3);
    }

    static int checkStyle(int n) {
        return Widget.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        RECT rECT = new RECT();
        OS.SendMessage(this.handle, 1049, 0, rECT);
        if ((this.style & 0x100) != 0) {
            n4 += OS.GetSystemMetrics(21) * 10;
            int n6 = OS.GetSystemMetrics(3);
            n5 += rECT.top * 2 + n6 + n6 / 3;
        } else {
            int n7 = OS.GetSystemMetrics(2);
            n4 += rECT.left * 2 + n7 + n7 / 3;
            n5 += OS.GetSystemMetrics(20) * 10;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        super.createHandle();
        OS.SendMessage(this.handle, 1032, 0, 100);
        OS.SendMessage(this.handle, 1045, 0, 10);
        OS.SendMessage(this.handle, 1044, 10, 0);
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    public int getIncrement() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1048, 0, 0);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1026, 0, 0);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1025, 0, 0);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1046, 0, 0);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1024, 0, 0);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void setBackgroundPixel(int n) {
        if (this.background == n) {
            return;
        }
        super.setBackgroundPixel(n);
        OS.PostMessage(this.handle, 7, 0, 0);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 1025, 0, 0);
        int n3 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n > n3 - n2) {
            return;
        }
        OS.SendMessage(this.handle, 1047, 0, n);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1025, 0, 0);
        if (n2 >= 0 && n2 < n) {
            OS.SendMessage(this.handle, 1032, 1, n);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n >= 0 && n < n2) {
            OS.SendMessage(this.handle, 1031, 1, n);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 1025, 0, 0);
        int n3 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n > n3 - n2) {
            return;
        }
        OS.SendMessage(this.handle, 1045, 0, n);
        OS.SendMessage(this.handle, 1044, n, 0);
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.SendMessage(this.handle, 1029, 1, n);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x10000 | 8 | 1;
        if ((this.style & 0x100) != 0) {
            return n;
        }
        return n | 2;
    }

    TCHAR windowClass() {
        return TrackBarClass;
    }

    int windowProc() {
        return TrackBarProc;
    }

    LRESULT wmScrollChild(int n, int n2) {
        int n3 = n & 0xFFFF;
        if (n3 == 8) {
            return null;
        }
        Event event = new Event();
        this.sendEvent(13, event);
        return null;
    }
}

