/*	Copyright (C) 2016  The Exult Team
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*	This file has a few shapes which I used in the mod. I intend to have them all
 *	one day in the file, but it will take some time.
 *
 *	2016-08-05 Updated by Knight Captain
 */

//Sprite effects
enum sprite_effects {
	ANIMATION_BIG_BLAST			= 1,
	ANIMATION_BIG_CLOUDS		= 2,
	ANIMATION_CLOUDS			= 3,
	ANIMATION_MEDIUM_BLAST		= 4,
	ANIMATION_SMALL_BLAST		= 5,
	ANIMATION_CLOUDS2			= 6,
	ANIMATION_TELEPORT			= 7,
	ANIMATION_DEATH_VORTEX		= 8,
	ANIMATION_POOF				= 9,
	ANIMATION_RED_DUST			= 11,
	ANIMATION_FIREWORKS			= 12,
	ANIMATION_GREEN_BUBBLES		= 13,
	ANIMATION_SPARKLES			= 16,
	ANIMATION_LIGHTNING			= 17,
	ANIMATION_BLUE_BEADS		= 18,
	ANIMATION_BURST_ARROW		= 19,
	ANIMATION_PURPLE_BUBBLES	= 21,
	ANIMATION_SWORD_STRIKE		= 23,
	ANIMATION_MUSIC				= 24,
	ANIMATION_TELEPORT2			= 26,
	ANIMATION_SMALL_RING_BLAST	= 27,
	ANIMATION_BIG_RING_BLAST	= 30,
	ANIMATION_MEDIUM_RING_BLAST	= 31,
	ANIMATION_RED_SWIRL			= 32,
	ANIMATION_PULSATING_DISC	= 33,
	ANIMATION_SERPENT_OVERLAY	= 39,
	ANIMATION_LIGHTNING_BLUE	= 40,
	ANIMATION_LIGHTNING_RED		= 41,
	ANIMATION_LIGHTNING_YELLOW	= 42,
	ANIMATION_LIGHTNING_GREEN	= 43,
	ANIMATION_TURTLE_RISE		= 46,
	ANIMATION_FROST_RING		= 47,
	ANIMATION_REVIVING_SNAKE	= 48,
	ANIMATION_EST_NUDI			= 50,
	ANIMATION_GOLDEN_SPARKLE	= 51,
	ANIMATION_PETRA_VISION		= 53,
	ANIMATION_ORB_BURST			= 54,
	ANIMATION_SWIRL_BARRIER		= 55,
	ANIMATION_SLASH_BURST		= 56,
	ANIMATION_VAMPIRE_RISING	= 61,
};

// Game engine items
enum egg_shapes {
	SHAPE_EGG = 275,
	SHAPE_USECODE_CONTAINER = 486,
	SHAPE_PATH_EGG = 607
};

// Animals from Earth
enum animals_shapes {
	SHAPE_PENGUIN = 298,
	SHAPE_BROWN_BEAR = 302,
	SHAPE_BOAR = 329,
	SHAPE_TIMBERWOLF = 447,
	SHAPE_POLAR_BEAR = 449,
	SHAPE_ALLIGATOR = 492,
	SHAPE_BAT = 493,
	SHAPE_CAT = 495,
	SHAPE_DOG = 496,
	SHAPE_CHICKEN = 498,
	SHAPE_COW = 500,
	SHAPE_DEER = 502,
	SHAPE_FISH = 509,						// Swims
	SHAPE_FOX = 510,
	SHAPE_INSECTS = 517,
	SHAPE_RAT = 523,
	SHAPE_SNAKE = 530,
	SHAPE_WOLF = 537,
	SHAPE_BIRD = 716,
	SHAPE_SNOW_LEOPARD = 754,
	SHAPE_PARROT = 772,						// Not on post
	SHAPE_RABBIT = 811,
	SHAPE_SHEEP = 970
};

enum monster_shapes {
	SHAPE_UNICORN = 375,					// Not used in SI?
	SHAPE_ACID_SLUG = 491,
	SHAPE_CORPSER = 499,
	SHAPE_GAZER = 511,
	SHAPE_DREAM_CREATURE = 521,
	SHAPE_REAPER = 524,
	SHAPE_SLIME = 529,
	SHAPE_TENTACLES = 536,
	SHAPE_PHOENIX = 702,
	SHAPE_ICE_CORPSER = 703,
	SHAPE_SCORPION = 706,
	SHAPE_ICE_WORM = 763,
	SHAPE_BABY_ICE_DRAGON = 798,
	SHAPE_FROST_SERPENT = 832,
	SHAPE_SPIDER = 865,
	SHAPE_ICE_DRAGON = 877,
	SHAPE_WINGED_VIPER = 882,
	SHAPE_NIGHTMARE = 885,
	SHAPE_ICE_CREATURE = 968,
	SHAPE_GREEN_DRAGON = 978,				// Draxinar
	SHAPE_MANSPIDER = 979
};

enum humanoid_monster_shapes {
	SHAPE_MAGIC_GREMLIN = 363,
	SHAPE_ICE_TROLL = 372,
	SHAPE_RATMAN = 382,
	SHAPE_CYCLOPS = 501,
	SHAPE_HEADLESS = 514,
	SHAPE_HARPIE = 532,
	SHAPE_TROLL = 533,
	SHAPE_SUIT_OF_ARMOUR = 550,				// Brass
	SHAPE_MONGBAT = 661,
	SHAPE_STONE_HARPY = 753,				// Yes, different spellings of harpy
	SHAPE_NAGA = 846,
	SHAPE_FIRE_ELEMENTAL = 861
};

enum undead_shapes {
	SHAPE_GHOUL_CHILD = 312,
	SHAPE_GHOST = 337,
	SHAPE_MUMMY = 373,
	SHAPE_SKELETAL_DRAGON = 460,
	SHAPE_GHOST_WOMAN = 482,				// Beatrix
	SHAPE_UNDEAD = 494,
	SHAPE_SKELETON = 528,
	SHAPE_GHOST_MAN = 853,
	SHAPE_LICHE = 981						// Aram Dol
};

enum goblin_shapes {
	SHAPE_GOBLIN_KING = 354,				// Pomdirgun
	SHAPE_GOBLIN_478 = 478,					// Correct offsets, immune to lightning
	SHAPE_GOBLIN_691 = 691,					// Correct offsets, vuln to magic, can't yell
	SHAPE_GOBLIN_725 = 725,					// Missing offsets so does not appear to hold weapons
	SHAPE_FEMALE_GOBLIN = 744,
	SHAPE_GOBLIN2 = 691						// Legacy
};

// Weapons - Special
enum special_weapon_shapes {
	SHAPE_MAGEBANE_SWORD = 231,				// Magic damage, takes away opponent's magic
	SHAPE_BRASS_HAMMER = 508,				// Used in Furnace Test
	SHAPE_WOODEN_SWORD = 520,
	SHAPE_DRAGONSLAYER_SWORD = 535,			// Normal damage
	SHAPE_MAGIC_SWORD = 547,				// Magic Damage, Lucky
	SHAPE_LIGHTNING_WHIP = 549,				// Magic damage
	SHAPE_FIRE_SWORD = 551,					// Fire damage
	SHAPE_MAGIC_AXE = 552,					// Magic damage
	SHAPE_FIREDOOM_STAFF = 553,				// Magic damage
	SHAPE_JUGGERNAUT_HAMMER = 557,			// Magic damage
	SHAPE_POISON_DAGGER = 564,
	SHAPE_SWORD_OF_DEFENSE = 567,
	SHAPE_GLASS_SWORD = 604,
	SHAPE_MAGIC_BOW = 606,
	SHAPE_LIGHTNING_WAND = 629,
	SHAPE_FIRE_WAND = 630,
	SHAPE_SERPENT_STAFF = 640,
	SHAPE_POWDER_KEG = 704,
	SHAPE_OPHIDIAN_SWORD = 710,
	SHAPE_INFINITY_BOW = 711,
	SHAPE_MAGICIANS_WAND = 792,
	SHAPE_BLACK_SWORD = 806,
	SHAPE_HAMMER_OF_DEDICATION = 942,
	SHAPE_ERINONS_AXE = 990
};

enum plain_weapon_shapes {
	SHAPE_STAFF = 241,
	SHAPE_BLOWGUN = 563,
	SHAPE_PITCHFORK = 589,					// Unused
	SHAPE_CLUB = 590,
	SHAPE_SPEAR = 592,
	SHAPE_THROWING_AXE = 593,
	SHAPE_DAGGER = 594,
	SHAPE_TORCH = 595,
	SHAPE_MORNING_STAR = 596,
	SHAPE_BOW = 597,
	SHAPE_CROSSBOW = 598,
	SHAPE_SWORD = 599,
	SHAPE_TWO_HANDED_HAMMER = 600,
	SHAPE_TWO_HANDED_AXE = 601,				// Battle Axe
	SHAPE_TWO_HANDED_SWORD = 602,
	SHAPE_HALBERD = 603,
	SHAPE_BOOMERANG = 605,
	SHAPE_DECORATIVE_SWORD = 608,
	SHAPE_SCYTHE = 618,
	SHAPE_RAKE = 620,
	SHAPE_WHIP = 622,
	SHAPE_HAMMER = 623,
	SHAPE_PICK = 624,
	SHAPE_SHOVEL = 625,
	SHAPE_HOE = 626,
	SHAPE_SERPENT_DAGGER = 636,
	SHAPE_SERPENT_SWORD = 637,
	SHAPE_MACE = 659,
	SHAPE_FISHING_ROD = 662,
	SHAPE_SHEARS = 698,
	SHAPE_LIT_TORCH = 701,
	SHAPE_TONGS = 994
};

enum ammo_shapes {
	SHAPE_MAGIC_BOLT = 417,
	SHAPE_BURST_ARROW = 554,
	SHAPE_MAGIC_ARROW = 556,
	SHAPE_LUCKY_ARROW = 558,
	SHAPE_SLEEP_ARROW = 568,
	SHAPE_SERPENT_ARROW = 591,
	SHAPE_ARROW = 722,
	SHAPE_BOLT = 723
};

enum armor_shapes {
	SHAPE_CLOAK = 227,
	SHAPE_MAGIC_HELM = 383,					// Includes Helm of Courage
	SHAPE_RED_CLOAK = 403,					// Only 1 frame
	SHAPE_BREAST_PLATE = 419,
	SHAPE_DUPRE_SHIELD = 490,
	SHAPE_CHAIN_COIF = 539,
	SHAPE_GREAT_HELM = 541,
	SHAPE_HELM = 542,						// Crested, plumed, Viking
	SHAPE_BUCKLER = 543,
	SHAPE_CURVED_HEATER = 545,
	SHAPE_LEATHER_ARMOUR = 569,
	SHAPE_SCALE_ARMOUR = 570,
	SHAPE_CHAIN_ARMOUR = 571,
	SHAPE_WOODEN_SHIELD = 572,
	SHAPE_PLATE_ARMOUR = 573,
	SHAPE_LEATHER_LEGGINGS = 574,
	SHAPE_CHAIN_LEGGINGS = 575,
	SHAPE_PLATE_LEGGINGS = 576,
	SHAPE_SPIKED_SHIELD = 578,
	SHAPE_LEATHER_GLOVES = 579,
	SHAPE_GAUNTLETS = 580,
	SHAPE_DOOR_SHIELD = 585,
	SHAPE_BRASS_SHIELD = 586,
	SHAPE_BOOTS = 587,						// All varieties
	SHAPE_KITE_SHIELD = 609,
	SHAPE_SERPENT_EARRINGS = 635,
	SHAPE_SERPENT_ARMOUR = 638,
	SHAPE_MAGIC_SHIELD = 663,
	SHAPE_MAGIC_ARMOUR = 666,
	SHAPE_MAGIC_LEGGINGS = 686,
	SHAPE_MONITOR_SHIELD = 729,				// Shield of Monitor
	SHAPE_MAGIC_GAUNTLETS = 835,
	SHAPE_ANTIQUE_ARMOUR = 836,
	SHAPE_BELT_OF_STRENGTH = 996,
	SHAPE_GAUNTLETS_OF_QUICKNESS = 1001,
	SHAPE_SOFT_HELM = 1004,					// Includes fur hats and the Serpent Crown, Living Toupee
	SHAPE_LEATHER_HELM = 1004,				// Legacy
	SHAPE_HELM_OF_LIGHT = 1013
};

enum money_shapes {
	SHAPE_GOLD_COIN = 644,
	SHAPE_GOLD_NUGGET = 645,
	SHAPE_GOLD_BAR = 646,
	SHAPE_GEM = 760,
	SHAPE_JEWELRY = 937,
	SHAPE_FILARI = 948,
	SHAPE_MONETARI = 951,
	SHAPE_GUILDER = 952
};

enum movable_item_shapes {
	SHAPE_MAP = 178,
	SHAPE_LARGE_SKULL = 244,				// Bear and mysterious cat skulls
	SHAPE_LARGE_SKELETON = 245,				// Bear and giant skeletons
	SHAPE_BLACKROCK_SERPENT = 262,
	SHAPE_PINECONE = 264,
	SHAPE_PUMICE = 267,
	SHAPE_TWIGS = 278,
	SHAPE_BRUSH = 285,
	SHAPE_DRUM = 286,						// Includes drumsticks
	SHAPE_SPECIAL_RING = 296,				// Invisibility, Regeneration, Blink, Reagents
	SHAPE_PLAINRING = 296,					// Per original si_shapes.uc
	SHAPE_UTENSIL = 300,
	SHAPE_BURNER = 307,
	SHAPE_SERPENT_RUNE = 330,				// Includes Virtue Stones
	SHAPE_LIGHT_SOURCE = 336,				// Candles
	SHAPE_LIT_LIGHT_SOURCE = 338,
	SHAPE_POTION = 340,
	SHAPE_FOOD = 377,
	SHAPE_FOOD_ON_TRAY = 404,				// Includes wolf meat and berry
	SHAPE_GARBAGE = 415,
	SHAPE_SOUL_PRISM = 445,
	SHAPE_ORB = 450,
	SHAPE_RED_WAND = 452,					// Crashes game
	SHAPE_FLUX_ANALYZER = 456,
	SHAPE_WHITE_WAND = 476,
	SHAPE_GWANI_AMULET = 479,				// Includes claw from Knight's Test
	SHAPE_KEY_RING = 485,
	SHAPE_MAGIC_HARP = 506,
	SHAPE_BROKEN_DISH = 546,
	SHAPE_SCEPTRE = 548,
	SHAPE_SERPENT_JAWBONE = 555,
	SHAPE_JAWBONE = 555,					// From original si_shapes.uc
	SHAPE_SERPENT_TOOTH = 559,
	SHAPE_SERPENT_TEETH = 559,				// From original si_shapes.uc
	SHAPE_PENGUIN_NEST = 577,				// Includes eggs and glowing egg
	SHAPE_NEST_EGG = 577,					// From original si_shapes.uc
	SHAPE_BEDROLL = 583,
	SHAPE_BOTTLE = 616,
	SHAPE_LOCKPICK = 627,
	SHAPE_CUP = 628,
	SHAPE_KEY = 641,
	SHAPE_BOOK = 642,
	SHAPE_SLEEPING_POWDER = 648,			// Includes Dust of Invisibility and Strange Potion
	SHAPE_ARTIFACT = 649,					// Plot Items
	SHAPE_SEXTANT = 650,
	SHAPE_BALE_OF_WOOL = 653,
	SHAPE_SPINDLE_OF_THREAD = 654,
	SHAPE_SWORD_BLANK = 668,				// called 'metal' in SI
	SHAPE_DESK_ITEMS = 675,					// Includes the abacus, clacker, and computer
	SHAPE_STOCKINGS = 677,
	SHAPE_JAR = 681,
	SHAPE_GLASS_ITEM = 682,
	SHAPE_SERPENT_CARVING = 688,			// Includes purple and gold statues
	SHAPE_LUTE = 692,
	SHAPE_WHISTLE = 693,
	SHAPE_PODIUM_V = 697,
	SHAPE_BOOK_2 = 705,
	SHAPE_BROWN_SCROLL = 707,				// Does it do anything?
	SHAPE_MAGIC_SCROLL = 715,
	SHAPE_PLATE = 717,
	SHAPE_DEAD_BABY = 730,					// Diapers can still be used on him.
	SHAPE_HARP = 745,
	SHAPE_LAB_APPARATUS = 749,				// Offically alchemist apparatus
	SHAPE_ALCHEMY_APPARATUS = 749,			// Legacy name
	SHAPE_MUSIC_BOX = 752,
	SHAPE_CALTROPS = 756,					// And broken glass that causes damage
	SHAPE_SPELLBOOK = 761,
	SHAPE_RUDYOMS_WAND = 771,
	SHAPE_PODIUM_H = 776,
	SHAPE_SEVERED_LIMB = 794,				// And hand
	SHAPE_SCROLL = 797,
	SHAPE_BODY_PART = 799,
	SHAPE_BUCKET = 810,
	SHAPE_DIAPER = 822,
	SHAPE_ARTISTS_EQUIPMENT = 823,			// Paintbrush
	SHAPE_PITCHER = 824,
	SHAPE_BANDAGE = 827,
	SHAPE_EASEL = 837,
	SHAPE_BIRD_CAGE = 838,
	SHAPE_HOURGLASS = 839,
	SHAPE_REAGENT = 842,
	SHAPE_CLOTH = 851,
	SHAPE_KITCHEN_ITEMS = 863,
	SHAPE_CHAIR = 873,
	SHAPE_RING = 887,						// Alyssand's and Serpent Ring
	SHAPE_BLOOD = 912,
	SHAPE_SPILL = 912,						// Legacy
	SHAPE_URN = 914,
	SHAPE_SERPENT_SCEPTRE = 926,
	SHAPE_PHILANDERERS_FRIEND = 929,		// Wand of Stone
	SHAPE_POT = 944,
	SHAPE_AMULET = 955,
	SHAPE_FUR_PELT = 977,
	SHAPE_MAGIC_COMPASS = 988
};

enum dead_body_shapes {
	SHAPE_BODY_400 = 400,					// 30 frames
	SHAPE_BODY_402 = 402,					// 31 frames with SS
	SHAPE_BODY_414 = 414,					// Dead 3 companions
	SHAPE_BODIES_2 = 414,					// From original si_shapes.uc
	SHAPE_BODY_SKELETON = 507,				// Includes Gwani bodies
	SHAPE_BODY_762 = 762,					// Mostly animals and monsters
	SHAPE_BODY_778 = 778,					// Larger monsters, dragons
	SHAPE_BODY_892 = 892					// With glowing cat
};

// Most containers here
enum container_shapes {
	SHAPE_SHIPS_HOLD = 405,
	SHAPE_LOCKED_CHEST = 522,
	SHAPE_LOCKEDCHEST = 522,				// Legacy
	SHAPE_CHEST = 800,
	SHAPE_BACKPACK = 801,
	SHAPE_BAG = 802,
	SHAPE_BASKET = 803,
	SHAPE_CRATE = 804,
	SHAPE_BARREL = 819
};

// Items that are too big to move by the player, or not intended to be moved.
// H for Horizontal, V for Vertical
enum too_big_to_move {
	SHAPE_CASK_V = 258,
	SHAPE_LOOM = 261,
	SHAPE_MIRROR_V = 268,					// Tall mirror
	SHAPE_DOOR_HORIZONTAL = 270,
	SHAPE_PAINTING_H = 282,
	SHAPE_DESK_V = 283,						// Includes blue desk
	SHAPE_SUNDIAL = 284,
	SHAPE_SEAT = 292,
	SHAPE_TAPESTRY_V = 293,					// Includes paintings
	SHAPE_HOLLOW_TREE = 297,
	SHAPE_BARRIER = 301,					// Used at Shamino's Keep
	SHAPE_METAL_WALL_EW = 303,
	SHAPE_TROPHY_V = 311,
	SHAPE_BASIN_H = 322,					// Rarely used
	SHAPE_FOUNTAIN = 326,
	SHAPE_ROCK = 331,
	SHAPE_SINGLE_TABLE_H = 333,				// Large single piece table
	SHAPE_LARGE_ROCK = 341,
	SHAPE_BOULDER = 342,
	SHAPE_BIG_BOULDER = 343,
	SHAPE_SHOP_SIGN_H = 360,
	SHAPE_SHOP_SIGN_V = 361,
	SHAPE_DOOR_VERTICAL = 376,
	SHAPE_STREET_SIGN = 379,
	SHAPE_WALL_OF_LIGHTS_RED = 380,
	SHAPE_NIGHTSTAND = 406,
	SHAPE_DESK_H = 407,
	SHAPE_TROPHY_H = 409,					// Includes white dragon head
	SHAPE_DRAWERS_H = 416,
	SHAPE_FORGE_BELLOWS = 431,
	SHAPE_DOOR_HORIZONTAL2 = 432,
	SHAPE_DOOR_VERTICAL2 = 433,
	SHAPE_CASK_H = 343,
	SHAPE_LIT_SCONCE = 435,
	SHAPE_LAMP_LIGHT_EFFECT = 440,			// Created by street lamps
	SHAPE_WELL = 471,
	SHAPE_WALL_OF_LIGHTS_BLUE = 473,
	SHAPE_WALL_OF_LIGHTS_GREEN = 475,		// Unused
	SHAPE_SCONCE = 481,
	SHAPE_MAGIC_LENS = 505,
	SHAPE_CRYSTAL_BALL = 519,				// Includes Moon's Eye
	SHAPE_LIT_LAMP = 526,					// Street lamps
	SHAPE_BROKEN_COLUMN = 544,
	SHAPE_MAGIC_MUSIC_PLAYER = 614,
	SHAPE_WALL_OF_LIGHTS_BALANCE = 615,
	SHAPE_WELL_OF_ENTHUSIASM = 617,
	SHAPE_SMALL_TABLE = 633,
	SHAPE_STANDING_STONE = 634,
	SHAPE_SPINNING_WHEEL = 651,
	SHAPE_PLANET = 655,
	SHAPE_WINE_VAT = 656,					// Includes wine press but not animated one
	SHAPE_CURTAIN_H = 657,
	SHAPE_SHRUBBERY = 672,
	SHAPE_CURTAIN_V = 678,
	SHAPE_DRAWERS_V = 679,
	SHAPE_PILLAR = 687,
	SHAPE_HARPSICHORD = 689,
	SHAPE_XYLOPHONE = 690,
	SHAPE_GRANDFATHER_CLOCK = 695,
	SHAPE_BED_H = 696,
	SHAPE_BASIN_V = 714,					// More common than H
	SHAPE_PEDESTAL = 718,
	SHAPE_WATER_TROUGH_V = 719,				// V
	SHAPE_MIRROR_ROCK = 727,				// Large Dream Crystal and Icy Column parts
	SHAPE_FORCE_WALL = 728,
	SHAPE_ARCHERY_TARGET = 735,
	SHAPE_FORGE_FIREPIT = 739,
	SHAPE_WINE_PRESS = 740,					// With animation
	SHAPE_WATER_TROUGH_H = 741,
	SHAPE_BLACK_SERPENT_STATUE = 743,		// With animation
	SHAPE_PILLAR_WITH_FACES = 746,
	SHAPE_ICE_BLOCK = 755,
	SHAPE_BELL = 759,
	SHAPE_PILLAR_3 = 777,
	SHAPE_WEB_OF_FATE = 784,
	SHAPE_COLUMN = 785,						// 1x1 Pillar
	SHAPE_LEVER = 787,
	SHAPE_SWITCH = 788,
	SHAPE_ASSIMILATION_MACHINE = 789,		// Erstam's
	SHAPE_ENGINE = 790,
	SHAPE_MANTLE = 795,
	SHAPE_CAMPFIRE = 796,					// Human head version was unused in SI
	SHAPE_PAINTING_V = 821,
	SHAPE_FIRE = 825,						// Non-magical fire
	SHAPE_MIRROR_H = 848,					// Tall mirror
	SHAPE_TAPESTRY_H = 849,
	SHAPE_FENCING_DUMMY = 860,
	SHAPE_MOONGATE = 864,
	SHAPE_METAL_WALL_NS = 876,
	SHAPE_SHATTERED_STATUE = 881,
	SHAPE_MONOLITH = 894,
	SHAPE_FIRE_FIELD = 895,
	SHAPE_SERPENT_SLOT = 927,
	SHAPE_TELESCOPE = 934,
	SHAPE_OPEN_METAL_WALL_NS = 935,
	SHAPE_OPEN_SLIDING_DOOR_V = 936,
	SHAPE_BRASS_WELL = 958
};

enum npc_shapes {
	SHAPE_MONK_RED_SASH = 179,
	SHAPE_GWANI_1 = 214,
	SHAPE_MAGE_IN_RED_GRAY_HAIR = 226,		// Melino
	SHAPE_PIKEMAN = 228,
	SHAPE_NAKED_MAN_BROWN_HAIR = 229,
	SHAPE_NAKED_WOMAN_BLONDE_HAIR = 230,	// Cindy
	SHAPE_JESTER = 247,
	SHAPE_XENKAN_MONK = 250,				// Thoxa, Karnax, etc.
	SHAPE_MALE_RANGER = 259,				// Ernesto
	SHAPE_TOWNSMAN = 265,					// Simon
	SHAPE_NOBLEWOMAN_IN_GREEN = 274,		// Yelinda
	SHAPE_GIRL_KNIGHT = 299,				// Cantra
	SHAPE_MAN_WITHOUT_SHIRT = 304,			// Standarr
	SHAPE_ANTI_SHAMINO = 317,
	SHAPE_ANTISHAMINO = 317,				// Legacy, from original si_shapes.uc
	SHAPE_BATLIN = 318,
	SHAPE_PEASANT = 319,					// Kane
	SHAPE_WILDMAN = 334,
	SHAPE_FAWN_GUARD = 381,					// Highwayman in BG
	SHAPE_XENKA = 392,
	SHAPE_MAGE_IN_ORANGE = 401,				// Ensorcio
	SHAPE_UGLY_OLD_WOMAN = 446,				// Mosh
	SHAPE_NOBLEMAN = 451,					// Marsten
	SHAPE_FEMALE_SHOPKEEPER = 454, 			// Harnna
	SHAPE_MALE_SHOPKEEPER = 455,			// Krayg
	SHAPE_GYPSY = 457,						// Hawk
	SHAPE_PIRATE = 458,						// Kalen
	SHAPE_FEMALE_RANGER = 461,				// Julia
	SHAPE_FIGHTER_GENERIC = 462,			// Templar (BG Sentri)
	SHAPE_PALADIN = 464,					// Caladin, Jorvin
	SHAPE_IOLO = 465,
	SHAPE_STRANGER = 468,					// Renfry
	SHAPE_WOMAN_REDHEAD = 469,				// Cellia
	SHAPE_BOY_IN_BLUE = 472,				// Freli
	SHAPE_WINGED_GARGOYLE = 480,			// Zhelkas
	SHAPE_SHAMINO = 487,
	SHAPE_DUPRE = 488,
	SHAPE_PRIESTESS = 560,					// Kylista
	SHAPE_FIGHTER_GREENHELM = 565,			// Brendann
	SHAPE_OLD_MAN = 581,					// Gustacio
	SHAPE_VAMPIRE = 588,					// Vasculio
	SHAPE_FEMALE_PIKEMAN = 647,				// Shazzana
	SHAPE_WOMAN_IN_BLUE_BLONDE = 652,		// Lydia
	SHAPE_FEMALE_AUTOMATON = 658,			// Petra
	SHAPE_SKINLESS_WOMAN = 660,				// Yelinda post-Banes
	SHAPE_DARK_FEMALE_MONK = 665,			// Witches in Silver Seed
	SHAPE_GWENNO = 669,
	SHAPE_GUARD = 720,						// Flicken
	SHAPE_MALE_AVATAR = 721,				// Avatar from BG per prior notes
	SHAPE_BRASS_AUTOMATON = 734,			// Silver Seed automatons
	SHAPE_WENCH = 742,						// Lucilla
	SHAPE_AUTOMATON = 747,					// Steel silver-colored automatons
	SHAPE_FEMALE_MAGE_IN_PINK = 766,		// Rotoluncia, Sabrina in MoF
	SHAPE_LORD_BRITISH = 793,
	SHAPE_FIGHTER_DARKSKIN = 805,			// Shmed
	SHAPE_MAGE_IN_BLACK = 809,				// Andral, Mortegro
	SHAPE_MAGE_IN_BLUE = 814,				// Filbercio
	SHAPE_BOYDON = 815,						// 'monster'
	SHAPE_FIGHTER_IN_ORANGE = 816,			// Luther
	SHAPE_MAGE_IN_BROWN = 817,				// Fedabiblio
	SHAPE_COUNSELOR = 818,					// Zulith
	SHAPE_MAN_WITH_BERET = 830,				// Spektor
	SHAPE_CAPTAIN = 855,					// Voldin
	SHAPE_GWANI_2 = 862,
	SHAPE_GWANI_CHILD = 867,				// Neyobi
	SHAPE_HOUND_OF_DOSKAR = 874,
	SHAPE_WINGLESS_GARGOYLE = 883,
	SHAPE_FEMALE_MAGE_IN_GREEN = 888,		// Columna
	SHAPE_MAD_IOLO = 880,
	SHAPE_NAKED_BROWN_MAN = 891,
	SHAPE_NAKED_BLACK_MAN = 893,
	SHAPE_ANTI_DUPRE = 906,
	SHAPE_ANTIDUPRE = 906,					// Legacy
	SHAPE_MAGELING = 916,
	SHAPE_TRAPPER = 917,
	SHAPE_NAKED_BLOND_MAN = 921,
	SHAPE_NAKED_BLONDE_WOMAN = 930,
	SHAPE_NAKED_BLACK_WOMAN = 933,
	SHAPE_NAKED_BROWN_WOMAN = 938,
	SHAPE_AUTOMATON_WITH_CAPE = 945,		// Isstanar
	SHAPE_HEALER = 946,
	SHAPE_OPHIDIAN_SOLDIER = 947,
	SHAPE_CATMAN = 957,
	SHAPE_FEMALE_AVATAR = 989,				// Avatar from BG per prior notes
	SHAPE_FEMALE_MAGE_IN_BLUE_GREEN = 1015	// Elissa

	// NPCs with unique appearances
	// These are the "old" avatar shapes:
	// SHAPE_MALE_AVATAR = 721,
	// SHAPE_FEMALE_AVATAR = 989,
};

enum lute_frames {
	FRAME_IOLOS_LUTE = 2
};

enum amulet_frames {
	FRAME_BATLINS_MEDALLION = 4,
	FRAME_DIAMOND_NECKLACE = 5,
	FRAME_WHITE_DIAMOND_NECKLACE = 8
};

const int FRAME_DRIED_FISH = 31;
